package hozo.sparql;

import java.util.HashMap;

public class EndpointSettingsManager {

	
	
	private HashMap<String, EndpointSettings> settingMap;
	
	private boolean isChanged = false;
	
	public static final EndpointSettingsManager instance = new EndpointSettingsManager();
	
	private EndpointSettingsManager(){
		
		settingMap = new HashMap<String, EndpointSettings>();
	}

	public EndpointSettings getSetting(String endpoint){
		EndpointSettings setting = settingMap.get(endpoint);
		if (setting == null){
			isChanged = true;
			setting = new EndpointSettings(endpoint);
			settingMap.put(endpoint, setting);
		}
		return setting;
		
	}
	
	public EndpointSettings[] getSettings(){
		return settingMap.values().toArray(new EndpointSettings[]{});
	}

	public void setSettings(EndpointSettings[] settings){
		settingMap = new HashMap<String, EndpointSettings>();
		
		for (EndpointSettings setting : settings){
			settingMap.put(setting.getEndpoint(), setting);
		}
	}

	public boolean removeSetting(String endpoint){
		EndpointSettings removed = settingMap.remove(endpoint);
		
		if (removed != null){
			isChanged = true;
		}
		
		return (removed != null);
	}
	
	public boolean isChanged(){
		if (isChanged){
			return true;
		}

		for (EndpointSettings setting : getSettings()){
			if (setting.isChanged()){
				isChanged = true;
				break;
			}
		}
		
		return isChanged;
	}
	
	public void resetChanged(){
		this.isChanged = false;

		for (EndpointSettings setting : getSettings()){
			setting.resetChanged();
		}

	}


}
