package org.biohackathon.SPARQLBuilder.OWL;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import org.biohackathon.SPARQLBuilder.endpointMetadata.MetadataFile;
import org.biohackathon.SPARQLBuilder.endpointMetadata.MetadataManager;

import jp.riken.accc.db.rdf.crawler.dataStructure.sparql.JenaModelGenerator;

public class RDFSchemaAnalyzerFactory {

	private MetadataManager metadataManager = null;
//	private Map<String, String> acquiredRDFFiles = null;
	private static final String FILENAME = "C:\\cdata";
        
        public RDFSchemaAnalyzerFactory(String fileName){
            try{
            	metadataManager = new MetadataManager(fileName);
//            	setAcqiredRDFFiles(new File(fileName));
            }catch(Exception e){
                System.err.println(e);
            }
        }

        public RDFSchemaAnalyzerFactory(){
            try{
            	metadataManager = new MetadataManager(FILENAME);
//            	setAcqiredRDFFiles(new File(FILENAME));
            }catch(Exception e){
                System.err.println(e);
            }
        }

//	private void setAcqiredRDFFiles(String dirFile) throws Exception{
//		setAcqiredRDFFiles(new File(dirFile));
//	}
	
//	private void setAcqiredRDFFiles(File data) throws Exception{
//		StructureCrawler sc = new StructureCrawler(data);
//		acquiredRDFFiles = sc.getAcquiredStructureFiles();
//	}

	public String[] getEndpointURIList(){
		return metadataManager.getURIList();
	}

	public MetadataFile[] getMetadataFiles(){
		return metadataManager.getMetadataFiles();
	}
	

	public RDFSchemaAnalyzer create(String uri) throws Exception{
		MetadataFile mFile = metadataManager.getMetadataFile(uri);
		if( mFile == null ){
			return new EndpointAnalyzer(uri);
		}else{
			JenaModelGenerator jmGene = new JenaModelGenerator(mFile.getFilePath());
			return new AcquiredStructureAnalyzer(jmGene.getEndpointURI(), jmGene.getGraphURIs(), jmGene.getModel());
		}
	}
}
