package org.biohackathon.SPARQLBuilder.OWL;

/**
 * 属しているクラスを保持してインスタンスを記述する
 * @author Norio KOBAYASHI
 * @since 28.01.2014
 * @version 29.01.2014
 */
public class Instance {

	private String instanceURI;
//	private Label instanceLabel;
	private String[] classURIs;
	
	/**
	 * インスタンスのURIとそのインスタンスが属しているすべてのクラスを与える構成子
	 * 
	 * @param instanceURI　インスタンスのURI
	 * @param classURIs　当該インスタンスが属しているすべてのクラスのURIの配列
	 * @throws Exception
	 * @since 28.01.2014
	 */
	public Instance(String instanceURI, String[] classURIs){
		this.instanceURI = instanceURI;
		this.classURIs = classURIs;
	}

	public String getInstanceURI() {
		return instanceURI;
	}

	public void setInstanceURI(String instanceURI) {
		this.instanceURI = instanceURI;
	}

	public String[] getClassURIs() {
		return classURIs;
	}

	public void setClassURIs(String[] classURIs) {
		this.classURIs = classURIs;
	}

	/**
	 * 文字列表記を取得する
	 * 
	 * @since 28.01.2014
	 */
	public String toString(){
		StringBuffer sb = new StringBuffer();
		sb.append(instanceURI);
		sb.append (" rdf:type ");
		sb.append("[");
		if( classURIs != null ){
			for( int i = 0; i < classURIs.length; i++ ){
				if( i != 0 ){
					sb.append(", ");
				}
				sb.append(classURIs[i]);
			}
		}
		sb.append("]");
		return sb.toString();
	}
	
	
}
