/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.util.Iterator;
import java.util.Stack;

public class PushbackIterator<T>
implements Iterator<T> {
    private Stack<T> items = new Stack();
    private Iterator<T> iter;

    public PushbackIterator(Iterator<T> iter) {
        if (iter == null) {
            throw new IllegalArgumentException("Wrapped iterator can't be null");
        }
        this.iter = iter;
    }

    public void pushback(T item) {
        this.items.push(item);
    }

    @Override
    public boolean hasNext() {
        if (!this.items.empty()) {
            return true;
        }
        return this.iter.hasNext();
    }

    @Override
    public T next() {
        if (!this.items.empty()) {
            return this.items.pop();
        }
        return this.iter.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

