/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelNodeBase;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.query.algebra.ValueConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Move
extends QueryModelNodeBase
implements UpdateExpr {
    private ValueConstant sourceGraph;
    private ValueConstant destinationGraph;
    private boolean silent;

    public Move() {
    }

    public Move(ValueConstant graph) {
        this.setSourceGraph(graph);
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        if (this.sourceGraph != null) {
            this.sourceGraph.visit(visitor);
        }
        if (this.destinationGraph != null) {
            this.destinationGraph.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.sourceGraph == current) {
            this.setSourceGraph((ValueConstant)replacement);
        } else if (this.destinationGraph == current) {
            this.setDestinationGraph((ValueConstant)replacement);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public Move clone() {
        Move clone = new Move();
        clone.setSilent(this.isSilent());
        if (this.getSourceGraph() != null) {
            clone.setSourceGraph(this.getSourceGraph().clone());
        }
        return clone;
    }

    public void setSourceGraph(ValueConstant graph) {
        this.sourceGraph = graph;
    }

    public ValueConstant getSourceGraph() {
        return this.sourceGraph;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    public void setDestinationGraph(ValueConstant destinationGraph) {
        this.destinationGraph = destinationGraph;
    }

    public ValueConstant getDestinationGraph() {
        return this.destinationGraph;
    }
}

