/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.optimizers;

import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.QueryRoot;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.impl.BindingAssigner;
import org.openrdf.query.algebra.evaluation.impl.CompareOptimizer;
import org.openrdf.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.openrdf.query.algebra.evaluation.impl.ConstantOptimizer;
import org.openrdf.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.openrdf.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.openrdf.sail.rdbms.RdbmsValueFactory;
import org.openrdf.sail.rdbms.optimizers.SelectQueryOptimizerFactory;
import org.openrdf.sail.rdbms.optimizers.SqlConstantOptimizer;
import org.openrdf.sail.rdbms.optimizers.ValueIdLookupOptimizer;
import org.openrdf.sail.rdbms.optimizers.ValueJoinOptimizer;
import org.openrdf.sail.rdbms.optimizers.VarColumnLookupOptimizer;
import org.openrdf.sail.rdbms.schema.BNodeTable;
import org.openrdf.sail.rdbms.schema.HashTable;
import org.openrdf.sail.rdbms.schema.LiteralTable;
import org.openrdf.sail.rdbms.schema.URITable;

public class RdbmsQueryOptimizer {
    private RdbmsValueFactory vf;
    private URITable uris;
    private BNodeTable bnodes;
    private LiteralTable literals;
    private SelectQueryOptimizerFactory factory;
    private HashTable hashTable;

    public void setSelectQueryOptimizerFactory(SelectQueryOptimizerFactory factory) {
        this.factory = factory;
    }

    public void setValueFactory(RdbmsValueFactory vf) {
        this.vf = vf;
    }

    public void setUriTable(URITable uris) {
        this.uris = uris;
    }

    public void setBnodeTable(BNodeTable bnodes) {
        this.bnodes = bnodes;
    }

    public void setLiteralTable(LiteralTable literals) {
        this.literals = literals;
    }

    public void setHashTable(HashTable hashTable) {
        this.hashTable = hashTable;
    }

    public TupleExpr optimize(TupleExpr expr, Dataset dataset, BindingSet bindings, EvaluationStrategy strategy) {
        TupleExpr tupleExpr = expr.clone();
        if (!(tupleExpr instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        this.coreOptimizations(strategy, tupleExpr, dataset, bindings);
        this.rdbmsOptimizations(tupleExpr, dataset, bindings);
        new SqlConstantOptimizer().optimize(tupleExpr, dataset, bindings);
        return tupleExpr;
    }

    private void coreOptimizations(EvaluationStrategy strategy, TupleExpr expr, Dataset dataset, BindingSet bindings) {
        new BindingAssigner().optimize(expr, dataset, bindings);
        new ConstantOptimizer(strategy).optimize(expr, dataset, bindings);
        new CompareOptimizer().optimize(expr, dataset, bindings);
        new ConjunctiveConstraintSplitter().optimize(expr, dataset, bindings);
        new DisjunctiveConstraintOptimizer().optimize(expr, dataset, bindings);
        new SameTermFilterOptimizer().optimize(expr, dataset, bindings);
    }

    protected void rdbmsOptimizations(TupleExpr expr, Dataset dataset, BindingSet bindings) {
        new ValueIdLookupOptimizer(this.vf).optimize(expr, dataset, bindings);
        this.factory.createRdbmsFilterOptimizer().optimize(expr, dataset, bindings);
        new VarColumnLookupOptimizer().optimize(expr, dataset, bindings);
        ValueJoinOptimizer valueJoins = new ValueJoinOptimizer();
        valueJoins.setBnodeTable(this.bnodes);
        valueJoins.setUriTable(this.uris);
        valueJoins.setLiteralTable(this.literals);
        valueJoins.setHashTable(this.hashTable);
        valueJoins.optimize(expr, dataset, bindings);
    }
}

