/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import org.openrdf.model.URI;
import org.openrdf.model.util.URIUtil;

public class URIImpl
implements URI {
    private static final long serialVersionUID = -7330406348751485330L;
    private String uriString;
    private int localNameIdx;

    protected URIImpl() {
    }

    public URIImpl(String uriString) {
        this.setURIString(uriString);
    }

    protected void setURIString(String uriString) {
        assert (uriString != null);
        if (uriString.indexOf(58) < 0) {
            throw new IllegalArgumentException("Not a valid (absolute) URI: " + uriString);
        }
        this.uriString = uriString;
        this.localNameIdx = -1;
    }

    public String toString() {
        return this.uriString;
    }

    public String stringValue() {
        return this.uriString;
    }

    public String getNamespace() {
        if (this.localNameIdx < 0) {
            this.localNameIdx = URIUtil.getLocalNameIndex(this.uriString);
        }
        return this.uriString.substring(0, this.localNameIdx);
    }

    public String getLocalName() {
        if (this.localNameIdx < 0) {
            this.localNameIdx = URIUtil.getLocalNameIndex(this.uriString);
        }
        return this.uriString.substring(this.localNameIdx);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof URI) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.uriString.hashCode();
    }
}

