/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp.impl;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.impl.AResourceInternal;
import com.hp.hpl.jena.rdf.arp.impl.AbsXMLContext;
import com.hp.hpl.jena.rdf.arp.impl.TaintImpl;
import com.hp.hpl.jena.rdf.arp.impl.UntaintableURIReference;
import com.hp.hpl.jena.rdf.arp.states.Frame;
import org.xml.sax.SAXParseException;

public class URIReference
extends TaintImpl
implements AResourceInternal,
ARPErrorNumbers {
    private final String uri;

    protected URIReference(String uri) {
        this.uri = uri;
        if (uri == null) {
            throw new NullPointerException();
        }
    }

    public String toString() {
        return this.uri;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public String getAnonymousID() {
        return null;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public Object getUserData() {
        throw new IllegalStateException("User data only supported on blank nodes");
    }

    @Override
    public void setUserData(Object d) {
        throw new IllegalStateException("User data only supported on blank nodes");
    }

    public boolean equals(Object o) {
        return o != null && o instanceof URIReference && this.uri.equals(((URIReference)o).uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public boolean hasNodeID() {
        return false;
    }

    @Override
    public void setHasBeenUsed() {
    }

    @Override
    public boolean getHasBeenUsed() {
        throw new UnsupportedOperationException("Internal error");
    }

    public static URIReference fromID(Frame f, AbsXMLContext x, String name) throws SAXParseException {
        URIReference rslt = URIReference.resolve(f, x, "#" + name);
        f.checkIdSymbol(rslt, x, name);
        return rslt;
    }

    public static URIReference resolve(Frame f, AbsXMLContext ctxt, String uri) throws SAXParseException {
        TaintImpl taintMe = new TaintImpl();
        IRI iri = ctxt.resolveAsURI(f.arp, taintMe, uri);
        f.checkEncoding(taintMe, uri);
        URIReference rslt = new URIReference(iri.toString());
        if (taintMe.isTainted()) {
            rslt.taint();
        }
        return rslt;
    }

    public static URIReference fromQName(Frame f, String ns, String local) throws SAXParseException {
        URIReference rslt = new URIReference(ns + local);
        f.checkEncoding(rslt, local);
        IRI iri = f.arp.iriFactory().create(ns + local);
        AbsXMLContext.checkURI(f.arp, rslt, iri);
        return rslt;
    }

    public static URIReference createNoChecks(String uri) {
        return new UntaintableURIReference(uri);
    }
}

