/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.ExceptionConvertingIteration;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.sail.nativerdf.NativeStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeTripleSource
implements TripleSource {
    protected final NativeStore nativeStore;
    protected final boolean includeInferred;
    protected final boolean readTransaction;

    protected NativeTripleSource(NativeStore store, boolean includeInferred, boolean readTransaction) {
        this.nativeStore = store;
        this.includeInferred = includeInferred;
        this.readTransaction = readTransaction;
    }

    @Override
    public CloseableIteration<? extends Statement, QueryEvaluationException> getStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
        try {
            return new ExceptionConvertingIteration<Statement, QueryEvaluationException>(this.nativeStore.createStatementIterator(subj, pred, obj, this.includeInferred, this.readTransaction, contexts)){

                @Override
                protected QueryEvaluationException convert(Exception e) {
                    if (e instanceof ClosedByInterruptException) {
                        return new QueryInterruptedException(e);
                    }
                    if (e instanceof IOException) {
                        return new QueryEvaluationException(e);
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e == null) {
                        throw new IllegalArgumentException("e must not be null");
                    }
                    throw new IllegalArgumentException("Unexpected exception type: " + e.getClass());
                }
            };
        }
        catch (IOException e) {
            throw new QueryEvaluationException("Unable to get statements", e);
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.nativeStore.getValueFactory();
    }
}

