/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.mgt.SystemInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openjena.atlas.lib.Sync;

public class SystemARQ {
    private static List<SystemInfo> versions = new ArrayList<SystemInfo>();

    public static void sync(Model model) {
        SystemARQ.sync(model.getGraph());
    }

    public static void sync(Graph graph) {
        SystemARQ.syncObject(graph);
    }

    public static void sync(Dataset dataset) {
        SystemARQ.sync(dataset.asDatasetGraph());
    }

    public static void sync(DatasetGraph dataset) {
        if (dataset instanceof Sync) {
            ((Sync)((Object)dataset)).sync();
            return;
        }
        Iterator<Node> iter = dataset.listGraphNodes();
        while (iter.hasNext()) {
            Node n = iter.next();
            Graph g = dataset.getGraph(n);
            SystemARQ.sync(g);
        }
    }

    public static void syncObject(Object object) {
        if (object instanceof Sync) {
            ((Sync)object).sync();
        }
    }

    public static void registerSubSystem(SystemInfo systemInfo) {
        versions.add(systemInfo);
    }

    public static Iterator<SystemInfo> registeredSubsystems() {
        return versions.iterator();
    }
}

