/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.engine.PlanBase;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIteratorCloseable;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.Utils;
import org.openjena.atlas.io.IndentedWriter;
import org.openjena.atlas.lib.Closeable;

public class PlanOp
extends PlanBase {
    private QueryIterator qIter;
    private String label = null;

    public PlanOp(Op op, Closeable closeable, QueryIterator qIter) {
        super(op, closeable);
        this.qIter = new QueryIteratorCloseable(qIter, this);
    }

    public PlanOp(String label, Closeable closeable, Op op, QueryIterator qIter) {
        this(op, closeable, qIter);
        this.label = label;
    }

    @Override
    protected QueryIterator iteratorOnce() {
        return this.qIter;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        if (this.getOp() == null) {
            out.println(Utils.className(this));
            return;
        }
        String str2 = this.label;
        if (this.label == null) {
            str2 = "Plan";
        }
        out.print("(");
        out.println(str2);
        out.incIndent();
        this.qIter.output(out, sCxt);
        out.print(")");
        out.decIndent();
        out.ensureStartOfLine();
    }
}

