/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIter1;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterTriplePattern;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import org.openjena.atlas.io.IndentedWriter;

public class QueryIterBlockTriples
extends QueryIter1 {
    private BasicPattern pattern;
    private Graph graph;
    private QueryIterator output;

    public static QueryIterator create(QueryIterator input, BasicPattern pattern, ExecutionContext execContext) {
        return new QueryIterBlockTriples(input, pattern, execContext);
    }

    private QueryIterBlockTriples(QueryIterator input, BasicPattern pattern, ExecutionContext execContext) {
        super(input, execContext);
        this.pattern = pattern;
        this.graph = execContext.getActiveGraph();
        QueryIterator chain = this.getInput();
        for (Triple triple : pattern) {
            chain = new QueryIterTriplePattern(chain, triple, execContext);
        }
        this.output = chain;
    }

    @Override
    protected boolean hasNextBinding() {
        return this.output.hasNext();
    }

    @Override
    protected Binding moveToNextBinding() {
        return this.output.nextBinding();
    }

    @Override
    protected void closeSubIterator() {
        if (this.output != null) {
            this.output.close();
        }
        this.output = null;
    }

    @Override
    protected void requestSubCancel() {
        if (this.output != null) {
            this.output.cancel();
        }
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print(Utils.className(this));
        out.println();
        out.incIndent();
        FmtUtils.formatPattern(out, this.pattern, sCxt);
        out.decIndent();
    }
}

