/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.checker;

import com.hp.hpl.jena.graph.Node;
import org.openjena.riot.ErrorHandler;
import org.openjena.riot.checker.NodeChecker;

public class CheckerBlankNodes
implements NodeChecker {
    private ErrorHandler handler;

    public CheckerBlankNodes(ErrorHandler handler) {
        this.handler = handler;
    }

    @Override
    public boolean check(Node node, long line, long col) {
        return node.isBlank() && this.checkBlank(node, line, col);
    }

    public boolean checkBlank(Node node, long line, long col) {
        String x = node.getBlankNodeLabel();
        if (x.indexOf(32) >= 0) {
            this.handler.error("Illegal blank node label (contains a space): " + node, line, col);
            return false;
        }
        return true;
    }
}

