/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.lang;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.AnonId;
import java.util.HashMap;
import java.util.Map;
import org.openjena.riot.out.NodeFmtLib;
import org.openjena.riot.system.MapWithScope;

public class LabelToNode
extends MapWithScope<String, Node, Node> {
    private static MapWithScope.Allocator<String, Node> nodeMaker = new MapWithScope.Allocator<String, Node>(){

        @Override
        public Node create(String label) {
            return Node.createAnon();
        }

        @Override
        public void reset() {
        }
    };
    private static MapWithScope.Allocator<String, Node> nodeMakerDeterministic = new MapWithScope.Allocator<String, Node>(){
        private long counter = 0L;

        @Override
        public Node create(String label) {
            String $ = String.format("B0x%04X", ++this.counter);
            return Node.createAnon((AnonId)new AnonId($));
        }

        @Override
        public void reset() {
        }
    };
    private static MapWithScope.Allocator<String, Node> nodeMakerByLabel = new MapWithScope.Allocator<String, Node>(){
        private long counter = 0L;

        @Override
        public Node create(String label) {
            if (label == null) {
                label = "genid" + this.counter++;
            }
            return Node.createAnon((AnonId)new AnonId(label));
        }

        @Override
        public void reset() {
        }
    };
    private static MapWithScope.Allocator<String, Node> nodeMakerByLabelEncoded = new MapWithScope.Allocator<String, Node>(){
        private long counter = 0L;

        @Override
        public Node create(String label) {
            if (label == null) {
                label = "genid" + this.counter++;
            }
            return Node.createAnon((AnonId)new AnonId(NodeFmtLib.decodeBNodeLabel(label)));
        }

        @Override
        public void reset() {
        }
    };

    public static LabelToNode createScopeByDocument() {
        return new LabelToNode(new SingleScopePolicy(), nodeMaker);
    }

    public static LabelToNode createScopeByGraph() {
        return new LabelToNode(new GraphScopePolicy(), nodeMaker);
    }

    public static LabelToNode createUseLabelAsGiven() {
        return new LabelToNode(new SingleScopePolicy(), nodeMakerByLabel);
    }

    public static LabelToNode createUseLabelEncoded() {
        return new LabelToNode(new SingleScopePolicy(), nodeMakerByLabelEncoded);
    }

    public static LabelToNode createIncremental() {
        return new LabelToNode(new SingleScopePolicy(), nodeMakerDeterministic);
    }

    public LabelToNode(MapWithScope.ScopePolicy<String, Node, Node> scopePolicy, MapWithScope.Allocator<String, Node> allocator) {
        super(scopePolicy, allocator);
    }

    private static class GraphScopePolicy
    implements MapWithScope.ScopePolicy<String, Node, Node> {
        private Map<String, Node> dftMap = new HashMap<String, Node>();
        private Map<Node, Map<String, Node>> map = new HashMap<Node, Map<String, Node>>();

        private GraphScopePolicy() {
        }

        @Override
        public Map<String, Node> getScope(Node scope) {
            if (scope == null) {
                return this.dftMap;
            }
            Map<String, Node> x = this.map.get(scope);
            if (x == null) {
                x = new HashMap<String, Node>();
                this.map.put(scope, x);
            }
            return x;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }

    private static class SingleScopePolicy
    implements MapWithScope.ScopePolicy<String, Node, Node> {
        private Map<String, Node> map = new HashMap<String, Node>();

        private SingleScopePolicy() {
        }

        @Override
        public Map<String, Node> getScope(Node scope) {
            return this.map;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

