/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.repository.AGValueFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.httpclient.HttpMethod;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.query.BindingSet;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.MapBindingSet;
import org.openrdf.query.resultio.QueryResultIO;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParser;

public class AGTQRHandler
extends AGResponseHandler {
    private final TupleQueryResultFormat format;
    private final TupleQueryResultHandler tqrhandler;
    private final AGValueFactory vf;

    public AGTQRHandler(TupleQueryResultFormat format, TupleQueryResultHandler tqrhandler, AGValueFactory vf, boolean recoverExternalBNodes) {
        super(format.getDefaultMIMEType());
        this.format = format;
        this.tqrhandler = recoverExternalBNodes ? this.recoverBNodesTQRHandler(tqrhandler) : tqrhandler;
        this.vf = vf;
    }

    @Override
    public void handleResponse(HttpMethod method) throws IOException, AGHttpException {
        String mimeType = this.getResponseMIMEType(method);
        if (!mimeType.equals(this.getRequestMIMEType())) {
            throw new AGHttpException("unexpected response MIME type: " + mimeType);
        }
        InputStream response = AGTQRHandler.getInputStream(method);
        try {
            TupleQueryResultParser parser = QueryResultIO.createParser((TupleQueryResultFormat)this.format, (ValueFactory)this.vf);
            parser.setTupleQueryResultHandler(this.recoverBNodesTQRHandler(this.tqrhandler));
            parser.parse(response);
        }
        catch (QueryResultParseException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
        catch (TupleQueryResultHandlerException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
    }

    private TupleQueryResultHandler recoverBNodesTQRHandler(final TupleQueryResultHandler handler) {
        return new TupleQueryResultHandler(){

            public void startQueryResult(List<String> arg0) throws TupleQueryResultHandlerException {
                handler.startQueryResult(arg0);
            }

            public void endQueryResult() throws TupleQueryResultHandlerException {
                handler.endQueryResult();
            }

            public void handleSolution(BindingSet arg0) throws TupleQueryResultHandlerException {
                Set names = arg0.getBindingNames();
                MapBindingSet sol = new MapBindingSet(names.size());
                for (String n : names) {
                    Value v = AGHttpRepoClient.getApplicationValue(arg0.getValue(n), AGTQRHandler.this.vf);
                    sol.addBinding(n, v);
                }
                handler.handleSolution((BindingSet)sol);
            }
        };
    }
}

