/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.storedproc;

import com.franz.agraph.http.storedproc.AGEncoder;
import com.franz.agraph.http.storedproc.ByteArray;
import java.util.List;

public class AGSerializer {
    private ByteArray barr = new ByteArray();

    public static String serializeAndEncode(Object[] data) {
        AGSerializer o = new AGSerializer();
        o.serializex(data);
        return AGEncoder.encode(o.finish());
    }

    public byte[] finish() {
        this.barr.addbyte((byte)10);
        byte[] retv = this.barr.extract();
        this.barr = null;
        return retv;
    }

    public AGSerializer serializex(Object obj) {
        if (obj instanceof String) {
            String str = (String)obj;
            this.barr.addbyte((byte)5);
            this.serializeInteger(str.length());
            for (int i = 0; i < str.length(); ++i) {
                this.barr.addbyte((byte)(str.codePointAt(i) & 0xFF));
            }
        } else if (obj instanceof Integer) {
            int i = (Integer)obj;
            if (i >= 0) {
                this.barr.addbyte((byte)9);
                this.serializeInteger(i);
            } else {
                this.barr.addbyte((byte)11);
                this.serializeInteger(-i);
            }
        } else if (obj instanceof Object[]) {
            Object[] vec = (Object[])obj;
            this.barr.addbyte((byte)1);
            this.serializeInteger(vec.length);
            for (int i = 0; i < vec.length; ++i) {
                this.serializex(vec[i]);
            }
        } else if (obj instanceof byte[]) {
            byte[] vec = (byte[])obj;
            this.barr.addbyte((byte)15);
            this.serializeInteger(vec.length);
            for (int i = 0; i < vec.length; ++i) {
                this.barr.addbyte(vec[i]);
            }
        } else if (obj instanceof List) {
            List vec = (List)obj;
            this.barr.addbyte((byte)8);
            this.serializeInteger(vec.size());
            for (int i = 0; i < vec.size(); ++i) {
                this.serializex(vec.get(i));
            }
            this.barr.addbyte((byte)7);
        } else if (obj == null) {
            this.barr.addbyte((byte)7);
        } else {
            throw new RuntimeException("cannot serialize object " + obj);
        }
        return this;
    }

    void serializeInteger(int i) {
        while (true) {
            byte lower = (byte)(i & 0x7F);
            int rest = i >> 7;
            if (rest != 0) {
                lower = (byte)(lower | 0x80);
            }
            this.barr.addbyte(lower);
            if (rest == 0) break;
            i = rest;
        }
    }
}

