/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.jena.AGBulkUpdateHandler;
import com.franz.agraph.jena.AGCapabilities;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGPrefixMapping;
import com.franz.agraph.jena.AGReifier;
import com.franz.agraph.jena.AGTransactionHandler;
import com.franz.agraph.jena.AGTripleIterator;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closeable;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.impl.ReifierFragmentHandler;
import com.hp.hpl.jena.graph.impl.ReifierFragmentsMap;
import com.hp.hpl.jena.graph.impl.ReifierTripleMap;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.ArrayList;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.DatasetImpl;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.StatementCollector;

public class AGGraph
extends GraphBase
implements Graph,
Closeable {
    protected final AGGraphMaker maker;
    protected final Node graphNode;
    protected AGRepositoryConnection conn;
    protected AGValueFactory vf;
    protected final Resource context;
    protected final Resource[] contexts;
    protected String entailmentRegime = "false";

    AGGraph(AGGraphMaker maker, Node graphNode) {
        super(maker.getReificationStyle());
        this.maker = maker;
        this.graphNode = graphNode;
        this.conn = maker.getRepositoryConnection();
        this.vf = this.conn.getValueFactory();
        this.context = this.vf.asResource(graphNode);
        this.contexts = new Resource[]{this.context};
    }

    AGGraph(AGGraphMaker maker, Resource context, Resource ... contexts) {
        super(maker.getReificationStyle());
        this.maker = maker;
        this.graphNode = null;
        this.conn = maker.getRepositoryConnection();
        this.vf = this.conn.getValueFactory();
        this.context = context;
        this.contexts = contexts;
    }

    AGGraphMaker getGraphMaker() {
        return this.maker;
    }

    Node getGraphNode() {
        return this.graphNode;
    }

    public String getName() {
        if (this.graphNode == null) {
            return "default-graph";
        }
        return this.graphNode.toString();
    }

    Resource getGraphContext() {
        return this.context;
    }

    Resource[] getGraphContexts() {
        return this.contexts;
    }

    AGRepositoryConnection getConnection() {
        return this.conn;
    }

    String getEntailmentRegime() {
        return this.entailmentRegime;
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        return new AGBulkUpdateHandler(this);
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AGCapabilities();
        }
        return this.capabilities;
    }

    public PrefixMapping getPrefixMapping() {
        return new AGPrefixMapping(this);
    }

    public TransactionHandler getTransactionHandler() {
        return new AGTransactionHandler(this);
    }

    public String toString() {
        return AGGraph.toString(this.getName() + (this.closed ? " (closed) " : " (size: " + this.graphBaseSize() + ")."), this);
    }

    public static String toString(String prefix, Graph that) {
        StringBuffer b = new StringBuffer(prefix + " {");
        String gap = "";
        ExtendedIterator it = GraphUtil.findAll((Graph)that);
        int count = 0;
        while (it.hasNext() && count < 20) {
            b.append(gap);
            gap = "; ";
            b.append(((Triple)it.next()).toString());
        }
        b.append("}");
        return b.toString();
    }

    Dataset getDataset() {
        DatasetImpl dataset = new DatasetImpl();
        for (Resource c : this.contexts) {
            if (c == null) {
                dataset.addDefaultGraph(null);
                continue;
            }
            if (!(c instanceof URI)) continue;
            dataset.addDefaultGraph((URI)c);
            dataset.addNamedGraph((URI)c);
        }
        return dataset;
    }

    protected ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        RepositoryResult result;
        try {
            Node s = m.getMatchSubject();
            Node p = m.getMatchPredicate();
            if (s != null && s.isLiteral() || p != null && (p.isLiteral() || p.isBlank())) {
                result = this.conn.createRepositoryResult(new ArrayList());
            } else {
                StatementCollector collector = new StatementCollector();
                this.conn.getHttpRepoClient().getStatements(this.vf.asResource(s), this.vf.asURI(p), this.vf.asValue(m.getMatchObject()), this.entailmentRegime, (RDFHandler)collector, this.contexts);
                result = this.conn.createRepositoryResult(collector.getStatements());
            }
        }
        catch (AGHttpException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
        return new AGTripleIterator(this, result);
    }

    public void performAdd(Triple t) {
        try {
            AGRepositoryConnection conn = this.maker.getRepositoryConnection();
            AGValueFactory vf = conn.getValueFactory();
            conn.add(vf.asResource(t.getSubject()), vf.asURI(t.getPredicate()), vf.asValue(t.getObject()), new Resource[]{this.context});
        }
        catch (UnauthorizedException e) {
            throw new AddDeniedException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void performDelete(Triple t) {
        try {
            this.conn.remove(this.vf.asResource(t.getSubject()), this.vf.asURI(t.getPredicate()), this.vf.asValue(t.getObject()), this.contexts);
        }
        catch (UnauthorizedException e) {
            throw new DeleteDeniedException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected int graphBaseSize() {
        int size;
        try {
            size = (int)this.conn.size(this.contexts);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return size;
    }

    public boolean isEmpty() {
        String queryString = "ask {?s ?p ?o}";
        AGBooleanQuery bq = this.conn.prepareBooleanQuery(QueryLanguage.SPARQL, queryString);
        bq.setDataset(this.getDataset());
        try {
            return !bq.evaluate();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    protected Reifier constructReifier() {
        if (!this.style.intercepts() && !this.style.conceals()) {
            return new SimpleReifier((GraphBase)this, (ReifierTripleMap)new EmptyReifierTripleMap(), (ReifierFragmentsMap)new EmptyReifierFragmentsMap(), this.style);
        }
        if (this.style == ReificationStyle.Standard) {
            return new AGReifier(this);
        }
        return new SimpleReifier((GraphBase)this, this.style);
    }

    class EmptyReifierFragmentsMap
    implements ReifierFragmentsMap {
        EmptyReifierFragmentsMap() {
        }

        public ExtendedIterator<Triple> find(TripleMatch m) {
            return NullIterator.instance();
        }

        public int size() {
            return 0;
        }

        public ReifierFragmentHandler getFragmentHandler(Triple fragment) {
            return null;
        }

        public boolean hasFragments(Node tag) {
            return false;
        }

        public void clear() {
        }
    }

    class EmptyReifierTripleMap
    implements ReifierTripleMap {
        EmptyReifierTripleMap() {
        }

        public Triple getTriple(Node tag) {
            return null;
        }

        public boolean hasTriple(Triple t) {
            return false;
        }

        public Triple putTriple(Node key, Triple value) {
            return null;
        }

        public void removeTriple(Node key) {
        }

        public void removeTriple(Node key, Triple value) {
        }

        public void removeTriple(Triple triple) {
        }

        public ExtendedIterator<Triple> find(TripleMatch m) {
            return NullIterator.instance();
        }

        public int size() {
            return 0;
        }

        public ExtendedIterator<Node> tagIterator() {
            return NullIterator.instance();
        }

        public ExtendedIterator<Node> tagIterator(Triple t) {
            return NullIterator.instance();
        }

        public void clear() {
        }
    }
}

