/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra;

import org.openrdf.query.algebra.BinaryValueOperator;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.ValueExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compare
extends BinaryValueOperator {
    private CompareOp operator;

    public Compare() {
    }

    public Compare(ValueExpr leftArg, ValueExpr rightArg) {
        this(leftArg, rightArg, CompareOp.EQ);
    }

    public Compare(ValueExpr leftArg, ValueExpr rightArg, CompareOp operator) {
        super(leftArg, rightArg);
        this.setOperator(operator);
    }

    public CompareOp getOperator() {
        return this.operator;
    }

    public void setOperator(CompareOp operator) {
        assert (operator != null) : "operator must not be null";
        this.operator = operator;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public String getSignature() {
        return super.getSignature() + " (" + this.operator.getSymbol() + ")";
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Compare && super.equals(other)) {
            Compare o = (Compare)other;
            return this.operator.equals((Object)o.getOperator());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.operator.hashCode();
    }

    @Override
    public Compare clone() {
        return (Compare)super.clone();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompareOp {
        EQ("="),
        NE("!="),
        LT("<"),
        LE("<="),
        GE(">="),
        GT(">");

        private String symbol;

        private CompareOp(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

