/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.federation;

import info.aduna.iteration.CloseableIteration;
import java.util.ArrayList;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.federation.FederatedService;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceManager;
import org.openrdf.query.algebra.evaluation.federation.JoinExecutorBase;
import org.openrdf.query.algebra.evaluation.iterator.CollectionIteration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceJoinIterator
extends JoinExecutorBase<BindingSet> {
    protected Service service;
    protected EvaluationStrategy strategy;

    public ServiceJoinIterator(CloseableIteration<BindingSet, QueryEvaluationException> leftIter, Service service, BindingSet bindings, EvaluationStrategy strategy) throws QueryEvaluationException {
        super(leftIter, service, bindings);
        this.service = service;
        this.strategy = strategy;
        this.run();
    }

    @Override
    protected void handleBindings() throws Exception {
        Var serviceRef = this.service.getServiceRef();
        if (!serviceRef.hasValue()) {
            while (!this.closed && this.leftIter.hasNext()) {
                this.addResult(this.strategy.evaluate(this.service, (BindingSet)this.leftIter.next()));
            }
            return;
        }
        String serviceUri = serviceRef.getValue().stringValue();
        FederatedService fs = FederatedServiceManager.getInstance().getService(serviceUri);
        int blockSize = 15;
        if (blockSize > 0) {
            while (this.leftIter.hasNext()) {
                ArrayList blockBindings = new ArrayList(blockSize);
                for (int i = 0; i < blockSize && this.leftIter.hasNext(); ++i) {
                    blockBindings.add(this.leftIter.next());
                }
                CollectionIteration<BindingSet, QueryEvaluationException> materializedIter = new CollectionIteration<BindingSet, QueryEvaluationException>(blockBindings);
                this.addResult(fs.evaluate(this.service, materializedIter, this.service.getBaseURI()));
            }
        } else {
            this.addResult(fs.evaluate(this.service, this.leftIter, this.service.getBaseURI()));
        }
    }
}

