/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import java.util.regex.Pattern;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;

public class Replace
implements Function {
    public String getURI() {
        return ((Object)FN.REPLACE).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length < 3 || args.length > 4) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for REPLACE: " + args.length);
        }
        try {
            Literal arg = (Literal)args[0];
            Literal pattern = (Literal)args[1];
            Literal replacement = (Literal)args[2];
            Literal flags = null;
            if (args.length == 4) {
                flags = (Literal)args[3];
            }
            if (arg.getDatatype() != null && !((Object)XMLSchema.STRING).equals(arg.getDatatype())) {
                throw new ValueExprEvaluationException("incompatible operand for REPLACE: " + arg);
            }
            if (pattern.getDatatype() != null || pattern.getLanguage() != null) {
                throw new ValueExprEvaluationException("incompatible operand for REPLACE: " + pattern);
            }
            if (replacement.getDatatype() != null || replacement.getLanguage() != null) {
                throw new ValueExprEvaluationException("incompatible operand for REPLACE: " + replacement);
            }
            String flagString = null;
            if (flags != null) {
                if (flags.getDatatype() != null || flags.getLanguage() != null) {
                    throw new ValueExprEvaluationException("incompatible operand for REPLACE: " + flags);
                }
                flagString = flags.getLabel();
            }
            String argString = arg.getLabel();
            String patternString = pattern.getLabel();
            String replacementString = replacement.getLabel();
            int f = 0;
            if (flagString != null) {
                block10: for (char c : flagString.toCharArray()) {
                    switch (c) {
                        case 's': {
                            f |= 0x20;
                            continue block10;
                        }
                        case 'm': {
                            f |= 8;
                            continue block10;
                        }
                        case 'i': {
                            f |= 2;
                            continue block10;
                        }
                        case 'x': {
                            f |= 4;
                            continue block10;
                        }
                        case 'd': {
                            f |= 1;
                            continue block10;
                        }
                        case 'u': {
                            f |= 0x40;
                            continue block10;
                        }
                        default: {
                            throw new ValueExprEvaluationException(flagString);
                        }
                    }
                }
            }
            Pattern p = Pattern.compile(patternString, f);
            String result = p.matcher(argString).replaceAll(replacementString);
            String lang = arg.getLanguage();
            URI dt = arg.getDatatype();
            if (lang != null) {
                return valueFactory.createLiteral(result, lang);
            }
            if (dt != null) {
                return valueFactory.createLiteral(result, dt);
            }
            return valueFactory.createLiteral(result);
        }
        catch (ClassCastException e) {
            throw new ValueExprEvaluationException("literal operands expected", e);
        }
    }
}

