/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.resultio.text.tsv;

import info.aduna.text.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.impl.ListBindingSet;
import org.openrdf.query.resultio.QueryResultParseException;
import org.openrdf.query.resultio.TupleQueryResultFormat;
import org.openrdf.query.resultio.TupleQueryResultParserBase;

public class SPARQLResultsTSVParser
extends TupleQueryResultParserBase {
    private List<String> bindingNames;

    public TupleQueryResultFormat getTupleQueryResultFormat() {
        return TupleQueryResultFormat.TSV;
    }

    public void parse(InputStream in) throws IOException, QueryResultParseException, TupleQueryResultHandlerException {
        String nextLine;
        InputStreamReader r = new InputStreamReader(in, Charset.forName("UTF-8"));
        BufferedReader reader = new BufferedReader(r);
        while ((nextLine = reader.readLine()) != null) {
            if (this.bindingNames == null) {
                String[] names = nextLine.split("\t", -1);
                this.bindingNames = Arrays.asList(names);
                this.handler.startQueryResult(this.bindingNames);
                continue;
            }
            String[] lineTokens = nextLine.split("\t", -1);
            ArrayList<BNode> values = new ArrayList<BNode>();
            for (String valueString : lineTokens) {
                Value v = null;
                if (valueString.startsWith("_:")) {
                    v = this.valueFactory.createBNode(valueString.substring(2));
                } else if (valueString.startsWith("\"")) {
                    v = this.parseLiteral(valueString);
                } else if (!"".equals(valueString)) {
                    try {
                        v = this.valueFactory.createURI(valueString);
                    }
                    catch (IllegalArgumentException e) {
                        v = this.valueFactory.createLiteral(valueString);
                    }
                }
                values.add((BNode)v);
            }
            ListBindingSet bindingSet = new ListBindingSet(this.bindingNames, values.toArray(new Value[values.size()]));
            this.handler.handleSolution(bindingSet);
        }
    }

    protected Literal parseLiteral(String literal) throws IllegalArgumentException {
        int endLabelIdx;
        if (literal.startsWith("\"") && (endLabelIdx = this.findEndOfLabel(literal)) != -1) {
            int startLangIdx = literal.indexOf("@", endLabelIdx);
            int startDtIdx = literal.indexOf("^^", endLabelIdx);
            if (startLangIdx != -1 && startDtIdx != -1) {
                throw new IllegalArgumentException("Literals can not have both a language and a datatype");
            }
            String label = literal.substring(1, endLabelIdx);
            label = this.unescapeString(label);
            if (startLangIdx != -1) {
                String language = literal.substring(startLangIdx + 1);
                return this.valueFactory.createLiteral(label, language);
            }
            if (startDtIdx != -1) {
                String datatype = literal.substring(startDtIdx + 2);
                URI dtURI = this.valueFactory.createURI(datatype);
                return this.valueFactory.createLiteral(label, dtURI);
            }
            return this.valueFactory.createLiteral(label);
        }
        throw new IllegalArgumentException("Not a legal literal: " + literal);
    }

    private int findEndOfLabel(String literal) {
        return literal.lastIndexOf("\"");
    }

    private String unescapeString(String s) {
        s = StringUtil.gsub("\\", "", s);
        return s;
    }
}

