/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONStringer {
    private static final int maxdepth = 20;
    private boolean comma = false;
    private char mode;
    private StringBuffer sb = new StringBuffer();
    private char[] stack = new char[20];
    private int top = 0;

    public JSONStringer() {
        this.mode = (char)105;
    }

    private JSONStringer append(String s) throws JSONException {
        if (s == null) {
            throw new JSONException("Null pointer");
        }
        if (this.mode == 'o' || this.mode == 'a') {
            if (this.comma && this.mode == 'a') {
                this.sb.append(',');
            }
            this.sb.append(s);
            if (this.mode == 'o') {
                this.mode = (char)107;
            }
            this.comma = true;
            return this;
        }
        throw new JSONException("Value out of sequence.");
    }

    public JSONStringer array() throws JSONException {
        if (this.mode == 'i' || this.mode == 'o' || this.mode == 'a') {
            this.push('a');
            this.append("[");
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced array.");
    }

    private JSONStringer end(char m, char c) throws JSONException {
        if (this.mode != m) {
            throw new JSONException(m == 'o' ? "Misplaced endObject." : "Misplaced endArray.");
        }
        this.pop(m);
        this.sb.append(c);
        this.comma = true;
        return this;
    }

    public JSONStringer endArray() throws JSONException {
        return this.end('a', ']');
    }

    public JSONStringer endObject() throws JSONException {
        return this.end('k', '}');
    }

    public JSONStringer key(String s) throws JSONException {
        if (s == null) {
            throw new JSONException("Null key.");
        }
        if (this.mode == 'k') {
            if (this.comma) {
                this.sb.append(',');
            }
            this.sb.append(JSONObject.quote(s));
            this.sb.append(':');
            this.comma = false;
            this.mode = (char)111;
            return this;
        }
        throw new JSONException("Misplaced key.");
    }

    public JSONStringer object() throws JSONException {
        if (this.mode == 'i') {
            this.mode = (char)111;
        }
        if (this.mode == 'o' || this.mode == 'a') {
            this.append("{");
            this.push('k');
            this.comma = false;
            return this;
        }
        throw new JSONException("Misplaced object.");
    }

    private void pop(char c) throws JSONException {
        if (this.top <= 0 || this.stack[this.top - 1] != c) {
            throw new JSONException("Nesting error.");
        }
        --this.top;
        this.mode = (char)(this.top == 0 ? 100 : this.stack[this.top - 1]);
    }

    private void push(char c) throws JSONException {
        if (this.top >= 20) {
            throw new JSONException("Nesting too deep.");
        }
        this.stack[this.top] = c;
        this.mode = c;
        ++this.top;
    }

    public JSONStringer value(boolean b) throws JSONException {
        return this.append(b ? "true" : "false");
    }

    public JSONStringer value(double d) throws JSONException {
        return this.value(new Double(d));
    }

    public JSONStringer value(long l) throws JSONException {
        return this.append(Long.toString(l));
    }

    public JSONStringer value(Object o) throws JSONException {
        if (JSONObject.NULL.equals(o)) {
            return this.append("null");
        }
        if (o instanceof Number) {
            JSONObject.testValidity(o);
            return this.append(JSONObject.numberToString((Number)o));
        }
        if (o instanceof Boolean || o instanceof JSONArray || o instanceof JSONObject) {
            return this.append(o.toString());
        }
        return this.append(JSONObject.quote(o.toString()));
    }

    public String toString() {
        return this.mode == 'd' ? this.sb.toString() : null;
    }
}

