/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.arnx.jsonic.util.BeanInfo;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private static final Map<ClassLoader, Map<String, Class<?>>> cache = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> findClass(String name) {
        LinkedHashMap map;
        ClassLoader cl;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException e) {
            cl = null;
        }
        Map<Object, Object> map2 = cache;
        synchronized (map2) {
            map = cache.get(cl);
            if (map == null) {
                map = new LinkedHashMap<String, Class<?>>(16, 0.75f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<String, Class<?>> eldest) {
                        return this.size() > 1024;
                    }
                };
                cache.put(cl, map);
            }
        }
        map2 = map;
        synchronized (map2) {
            if (!map.containsKey(name)) {
                Class<?> target;
                try {
                    target = cl != null ? cl.loadClass(name) : Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    target = null;
                }
                map.put(name, target);
            }
        }
        return (Class)map.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<ClassLoader, Map<String, Class<?>>> map = cache;
        synchronized (map) {
            cache.clear();
        }
    }

    public static String toUpperCamel(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toUpperCase = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                sb.append(Character.toUpperCase(c));
                toUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toLowerCamel(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toUpperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                sb.append(Character.toUpperCase(c));
                toUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(0)) && !Character.isUpperCase(sb.charAt(1))) {
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static Class<?> getRawType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof GenericArrayType) {
            Class<?> cls = null;
            try {
                cls = Array.newInstance(ClassUtil.getRawType(((GenericArrayType)t).getGenericComponentType()), 0).getClass();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return cls;
        }
        if (t instanceof WildcardType) {
            Type[] types = ((WildcardType)t).getUpperBounds();
            return types.length > 0 ? ClassUtil.getRawType(types[0]) : Object.class;
        }
        return Object.class;
    }

    public static ParameterizedType resolveParameterizedType(Type t, Class<?> baseClass) {
        Class<?> raw = ClassUtil.getRawType(t);
        if (t instanceof ParameterizedType && baseClass.isAssignableFrom(raw)) {
            return (ParameterizedType)t;
        }
        ParameterizedType pt = null;
        if (raw.getSuperclass() != null && raw.getSuperclass() != Object.class && (pt = ClassUtil.resolveParameterizedType(raw.getGenericSuperclass(), baseClass)) != null) {
            return pt;
        }
        if (!raw.isInterface()) {
            for (Type ifs : raw.getGenericInterfaces()) {
                pt = ClassUtil.resolveParameterizedType(ifs, baseClass);
                if (pt == null) continue;
                return pt;
            }
        }
        return null;
    }

    public static byte[] serialize(Object o) throws ObjectStreamException {
        ByteArrayOutputStream array = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(array);
            out.writeObject(o);
            out.close();
        }
        catch (ObjectStreamException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return array.toByteArray();
    }

    public static Object deserialize(byte[] data) throws ObjectStreamException, ClassNotFoundException {
        Object ret = null;
        ContextObjectInputStream in = null;
        try {
            in = new ContextObjectInputStream(new ByteArrayInputStream(data));
            ret = in.readObject();
            in.close();
        }
        catch (ObjectStreamException e) {
            throw e;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public static int hashCode(Object target) {
        if (target == null) {
            return 0;
        }
        int prime = 31;
        int result = 1;
        Class<?> current = target.getClass();
        do {
            for (Field f : current.getDeclaredFields()) {
                Object self;
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || f.isSynthetic()) continue;
                try {
                    f.setAccessible(true);
                    self = f.get(target);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                if (self == null) {
                    result = 31 * result + 0;
                    continue;
                }
                if (current.isArray()) {
                    if (current.equals(boolean[].class)) {
                        result = 31 * result + Arrays.hashCode((boolean[])self);
                        continue;
                    }
                    if (current.equals(char[].class)) {
                        result = 31 * result + Arrays.hashCode((char[])self);
                        continue;
                    }
                    if (current.equals(byte[].class)) {
                        result = 31 * result + Arrays.hashCode((byte[])self);
                        continue;
                    }
                    if (current.equals(short[].class)) {
                        result = 31 * result + Arrays.hashCode((short[])self);
                        continue;
                    }
                    if (current.equals(int[].class)) {
                        result = 31 * result + Arrays.hashCode((int[])self);
                        continue;
                    }
                    if (current.equals(long[].class)) {
                        result = 31 * result + Arrays.hashCode((long[])self);
                        continue;
                    }
                    if (current.equals(float[].class)) {
                        result = 31 * result + Arrays.hashCode((float[])self);
                        continue;
                    }
                    if (current.equals(double[].class)) {
                        result = 31 * result + Arrays.hashCode((double[])self);
                        continue;
                    }
                    result = 31 * result + Arrays.hashCode((Object[])self);
                    continue;
                }
                result = 31 * result + self.hashCode();
            }
        } while (!Object.class.equals(current = current.getSuperclass()));
        return result;
    }

    public static boolean equals(Object target, Object o) {
        if (target == o) {
            return true;
        }
        if (target == null || o == null) {
            return false;
        }
        if (!target.getClass().equals(o.getClass())) {
            return false;
        }
        Class<?> current = target.getClass();
        do {
            for (Field f : current.getDeclaredFields()) {
                Object other;
                Object self;
                if (Modifier.isStatic(f.getModifiers()) || Modifier.isTransient(f.getModifiers()) || f.isSynthetic()) continue;
                try {
                    f.setAccessible(true);
                    self = f.get(target);
                    other = f.get(o);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                if (!(self == null ? other != null : (current.isArray() ? (current.equals(boolean[].class) ? !Arrays.equals((boolean[])self, (boolean[])other) : (current.equals(char[].class) ? !Arrays.equals((char[])self, (char[])other) : (current.equals(byte[].class) ? !Arrays.equals((byte[])self, (byte[])other) : (current.equals(short[].class) ? !Arrays.equals((short[])self, (short[])other) : (current.equals(int[].class) ? !Arrays.equals((int[])self, (int[])other) : (current.equals(long[].class) ? !Arrays.equals((long[])self, (long[])other) : (current.equals(float[].class) ? !Arrays.equals((float[])self, (float[])other) : (current.equals(double[].class) ? !Arrays.equals((double[])self, (double[])other) : !Arrays.equals((Object[])self, (Object[])other))))))))) : !self.equals(other)))) continue;
                return false;
            }
        } while (!Object.class.equals(current = current.getSuperclass()));
        return true;
    }

    public static String toString(Object target) {
        if (target == null) {
            return "null";
        }
        BeanInfo info = BeanInfo.get(target.getClass());
        StringBuilder sb = new StringBuilder(10 * info.getProperties().size() + 20);
        sb.append(target.getClass().getSimpleName()).append(" [");
        boolean first = true;
        for (PropertyInfo prop : info.getProperties()) {
            if (!prop.isReadable() || prop.getName().equals("class")) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(prop.getName()).append("=");
            try {
                Object value = prop.get(target);
                if (value.getClass().isArray()) {
                    if (value instanceof boolean[]) {
                        Arrays.toString((boolean[])value);
                        continue;
                    }
                    if (value instanceof char[]) {
                        Arrays.toString((char[])value);
                        continue;
                    }
                    if (value instanceof byte[]) {
                        Arrays.toString((byte[])value);
                        continue;
                    }
                    if (value instanceof short[]) {
                        Arrays.toString((short[])value);
                        continue;
                    }
                    if (value instanceof int[]) {
                        Arrays.toString((int[])value);
                        continue;
                    }
                    if (value instanceof long[]) {
                        Arrays.toString((long[])value);
                        continue;
                    }
                    if (value instanceof float[]) {
                        Arrays.toString((float[])value);
                        continue;
                    }
                    if (value instanceof double[]) {
                        Arrays.toString((double[])value);
                        continue;
                    }
                    Arrays.toString((Object[])value);
                    continue;
                }
                sb.append(value);
            }
            catch (Exception e) {
                sb.append("?");
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private ClassUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextObjectInputStream
    extends ObjectInputStream {
        public ContextObjectInputStream(InputStream in) throws IOException {
            super(in);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                return Class.forName(desc.getName(), true, cl);
            }
            catch (Exception e) {
                return super.resolveClass(desc);
            }
        }
    }
}

