/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biohackathon.SPARQLBuilder.OWL;

/**
 *
 * @author atsuko
 */
import java.util.*;


public class LabeledMultiDigraph {
    List<List<LabeledEdge>> adjlist;
    List<String> labels;
    HashMap<String,Integer> labelednodes;
    
    public class LabeledEdge{
        Integer node;
        String label;
        Direction direction;
        Integer ntriples;
        
        public LabeledEdge(Integer node, String label, Direction direction, Integer ntriples){
            this.node = node;
            this.label = label;
            this.direction = direction;
            this.ntriples = ntriples;
        }
    }
    
    public LabeledMultiDigraph(){
        adjlist = new ArrayList<List<LabeledEdge>>();
        labels = new LinkedList<String>();
        labelednodes = new HashMap<String, Integer>();
    }
    
    public void addNode(String label){
        labelednodes.put(label, labels.size());
        labels.add(label);
        adjlist.add(new LinkedList<LabeledEdge>());
    }
    
    public void addEdge(Integer node1, Integer node2, String elabel, Direction direction, Integer ntriples){
        if ( labels.size() < node1 || labels.size() < node2 ){
            System.err.println("Error for Edge Addition: No Node for the Edge");
            return;
        }
        LabeledEdge edge = new LabeledEdge(node2, elabel, direction, ntriples);
        adjlist.get(node1).add(edge);
    }
}
