/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGVirtualRepository;
import com.franz.util.Closeable;
import com.franz.util.Closer;
import java.util.ArrayList;
import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;

public class AGServer
implements Closeable {
    private final String serverURL;
    private final AGHTTPClient httpClient;
    private final AGCatalog rootCatalog;

    public AGServer(String serverURL, String username, String password) {
        this.serverURL = serverURL;
        this.httpClient = new AGHTTPClient(serverURL);
        this.httpClient.setUsernameAndPassword(username, password);
        this.rootCatalog = new AGCatalog(this, 0);
    }

    public AGServer(String username, String password, AGHTTPClient httpClient) {
        this.serverURL = httpClient.getServerURL();
        this.httpClient = httpClient;
        this.httpClient.setUsernameAndPassword(username, password);
        this.rootCatalog = new AGCatalog(this, 0);
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public AGHTTPClient getHTTPClient() {
        return this.httpClient;
    }

    public String getVersion() throws AGHttpException {
        return this.getHTTPClient().getString(this.serverURL + "/version");
    }

    public String getBuildDate() throws AGHttpException {
        return this.getHTTPClient().getString(this.serverURL + "/version/date");
    }

    public String getRevision() throws AGHttpException {
        return this.getHTTPClient().getString(this.serverURL + "/version/revision");
    }

    public AGCatalog getRootCatalog() {
        return this.rootCatalog;
    }

    public List<String> listCatalogs() throws AGHttpException {
        String url = AGProtocol.getNamedCatalogsURL(this.serverURL);
        TupleQueryResult tqresult = this.getHTTPClient().getTupleQueryResult(url);
        ArrayList<String> result = new ArrayList<String>(5);
        try {
            while (tqresult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqresult.next();
                Value id = bindingSet.getValue("id");
                result.add(id.stringValue());
            }
        }
        catch (QueryEvaluationException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
        return result;
    }

    public AGCatalog getCatalog(String catalogID) throws AGHttpException {
        if (AGCatalog.isRootID(catalogID)) {
            return this.rootCatalog;
        }
        if (this.listCatalogs().contains(catalogID)) {
            return new AGCatalog(this, catalogID);
        }
        return null;
    }

    public AGCatalog getCatalog() {
        return this.rootCatalog;
    }

    public AGCatalog createCatalog(String catalogID) throws AGHttpException {
        AGCatalog catalog = this.getCatalog(catalogID);
        if (catalog == null) {
            String catalogURL = AGProtocol.getNamedCatalogLocation(this.getServerURL(), catalogID);
            this.getHTTPClient().putCatalog(catalogURL);
            catalog = new AGCatalog(this, catalogID);
        }
        return catalog;
    }

    public void deleteCatalog(String catalogID) throws AGHttpException {
        String catalogURL = AGProtocol.getNamedCatalogLocation(this.getServerURL(), catalogID);
        this.getHTTPClient().deleteCatalog(catalogURL);
    }

    public AGVirtualRepository virtualRepository(String storeSpec) {
        return new AGVirtualRepository(this, storeSpec, null);
    }

    public AGVirtualRepository federate(AGAbstractRepository ... repositories) {
        String[] specstrings = new String[repositories.length];
        for (int i = 0; i < repositories.length; ++i) {
            specstrings[i] = repositories[i].getSpec();
        }
        String spec = AGVirtualRepository.federatedSpec(specstrings);
        return new AGVirtualRepository(this, spec, null);
    }

    @Override
    public void close() {
        Closer.Close(this.httpClient);
    }
}

