/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.Map;

public class Mapping
implements VariableIndexes {
    private Map<Node, Integer> map = CollectionFactory.createHashedMap();
    private int index = 0;
    private int preIndex = 0;

    public Mapping(Node[] preDeclare) {
        this.index = preDeclare.length;
        for (int i = 0; i < preDeclare.length; ++i) {
            this.preDeclare(preDeclare[i]);
        }
    }

    private void preDeclare(Node v) {
        this.map.put(v, new Integer(--this.preIndex));
    }

    public int indexOf(Node v) {
        int res = this.lookUp(v);
        if (res < 0) {
            throw new Query.UnboundVariableException(v);
        }
        return res;
    }

    @Override
    public int indexOf(String name) {
        return this.indexOf(Node.createVariable(name));
    }

    public int lookUp(Node v) {
        Integer i = this.map.get(v);
        if (i == null || i < 0) {
            return -1;
        }
        return i;
    }

    public int newIndex(Node v) {
        int n;
        Integer already = this.map.get(v);
        if (already == null) {
            int n2 = this.index;
            n = n2;
            this.index = n2 + 1;
        } else {
            n = -already.intValue() - 1;
        }
        int result = n;
        this.map.put(v, new Integer(result));
        return result;
    }

    public int size() {
        return this.map.size();
    }

    public boolean hasBound(Node v) {
        return this.map.containsKey(v) && this.map.get(v) > -1;
    }

    public String toString() {
        return this.map.toString();
    }
}

