/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.iterator;

import java.io.Closeable;
import java.util.Iterator;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.io.IO;
import org.openjena.atlas.iterator.Iter;

public class IteratorResourceClosing<T>
implements Iterator<T>,
org.openjena.atlas.lib.Closeable {
    private final Iterator<T> iter;
    private final Closeable resource;
    private boolean finished;

    public IteratorResourceClosing(Iterator<T> iter, Closeable resource) {
        this.iter = iter;
        this.resource = resource;
        this.finished = false;
    }

    private void checkFinished() {
        if (this.finished) {
            throw new AtlasException("IteratorResourceClosing is closed, no further operations can be performed on it.");
        }
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        boolean toReturn = this.iter.hasNext();
        if (!toReturn) {
            this.close();
        }
        return toReturn;
    }

    @Override
    public T next() {
        this.checkFinished();
        return this.iter.next();
    }

    @Override
    public void remove() {
        this.checkFinished();
        this.iter.remove();
    }

    @Override
    public void close() {
        if (!this.finished) {
            Iter.close(this.iter);
            IO.close(this.resource);
            this.finished = true;
        }
    }
}

