/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.atlas.lib;

import java.io.File;
import org.openjena.atlas.AtlasException;
import org.openjena.atlas.lib.Tuple;
import org.openjena.atlas.logging.Log;

public class FileOps {
    private FileOps() {
    }

    public static void delete(String filename) {
        FileOps.delete(new File(filename), true);
    }

    public static void deleteSilent(String filename) {
        FileOps.delete(new File(filename), false);
    }

    public static void delete(File f, boolean reportExistsAfter) {
        try {
            f.delete();
            if (reportExistsAfter && f.exists()) {
                Log.warn(FileOps.class, "delete: *** File still exists: " + f);
            }
        }
        catch (SecurityException ex) {
            Log.warn(FileOps.class, "delete: " + f + ": Security exception; " + ex.getMessage());
        }
    }

    public static void clearDirectory(String dir) {
        File d = new File(dir);
        for (File f : d.listFiles()) {
            if (!f.isFile()) continue;
            FileOps.delete(f, false);
        }
    }

    public static boolean existsAnyFiles(String dir) {
        File d = new File(dir);
        File[] entries = d.listFiles();
        if (entries == null) {
            return false;
        }
        return entries.length > 0;
    }

    public static boolean exists(String path) {
        File f = new File(path);
        return f.exists();
    }

    public static boolean isEmpty(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            return true;
        }
        if (f.isFile()) {
            return f.length() == 0L;
        }
        throw new AtlasException("Not a file");
    }

    public static void ensureDir(String dirname) {
        File dir = new File(dirname);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public static Tuple<String> splitDirBaseExt(String filename) {
        int i;
        String path = null;
        String basename = filename;
        String ext = null;
        int j = filename.lastIndexOf(47);
        if (j < 0) {
            j = filename.lastIndexOf(92);
        }
        if (j >= 0) {
            path = filename.substring(0, j);
            basename = filename.substring(j + 1);
        }
        if ((i = basename.lastIndexOf(46)) > -1) {
            ext = basename.substring(i + 1);
            basename = basename.substring(0, i);
        }
        return Tuple.create(path, basename, ext);
    }

    public static Tuple<String> splitDirFile(String filename) {
        String path = null;
        String fn = filename;
        int j = filename.lastIndexOf(47);
        if (j < 0) {
            j = filename.lastIndexOf(92);
        }
        if (j >= 0) {
            path = filename.substring(0, j);
            fn = filename.substring(j + 1);
        }
        return Tuple.create(path, fn);
    }

    public static String basename(String filename) {
        int j = filename.lastIndexOf(47);
        if (j < 0) {
            j = filename.lastIndexOf(92);
        }
        if (j >= 0) {
            return filename.substring(j + 1);
        }
        return filename;
    }
}

