/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biohackathon.SPARQLBuilder.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.*;
import javax.json.*;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.biohackathon.SPARQLBuilder.OWL.*;

/**
 *
 * @author atsuko
 */
@WebServlet(name = "CLServlet", urlPatterns = {"/clist"})
public class CLServlet extends HttpServlet {

    private static final String FILENAME = "cdata/";
    
    /**
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code>
     * methods.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        try (PrintWriter out = response.getWriter()) {
            /* TODO output your page here. You may use following sample code. */
            out.println("<!DOCTYPE html>");
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Servlet CLServlet</title>");            
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Servlet CLServlet at " + request.getContextPath() + "</h1>");
            out.println("</body>");
            out.println("</html>");
        }
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /**
     * Handles the HTTP <code>GET</code> method.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        //processRequest(request, response);
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "GET");
        response.setHeader("Access-Control-Allow-Headers", request.getHeader("Access-Control-Request-Headers"));
        response.setHeader("Access-Control-Max-Age", "-1");     
	PrintWriter out = response.getWriter();
        String ep = request.getParameter("ep");
        HttpSession session = request.getSession();
        QueryPathGenerator qpg = (QueryPathGenerator)session.getAttribute("qpg");
        if ( qpg == null ){
                   qpg = new QueryPathGenerator();
        }
        SortedSet<String> sortedClasses = new TreeSet<String>(); // display + url
        qpg.setSPARQLendpoint(ep);
        SClass[] classes = qpg.getClasses(null);
        for (int i = 0 ; i < classes.length; i++ ){
            String uri = classes[i].getClassURI();
            Label[] labels = classes[i].getLabels();
            String label = null;
            for ( int j = 0 ; j < labels.length; j++ ){
                if ( labels[j].getLanguage() == null ){
                    label = labels[j].getLabel(); break;
                }else if ( labels[j].getLanguage().equals("en") ){
                    label = labels[j].getLabel(); break;
                }
            }
            if ( label == null ){
                String[] uris = uri.split("/");
                String tmplabel = uris[uris.length-1];
                String[] tmplabel2 = tmplabel.split("#");
                label = tmplabel2[tmplabel2.length-1];
            }
            StringBuilder classbuilder = new StringBuilder(label);
            classbuilder.append("  ");
            classbuilder.append(classes[i].getNumOfInstances());
            classbuilder.append("  ");
            classbuilder.append(uri);
            sortedClasses.add(classbuilder.toString());
        }
        JsonBuilderFactory jbfactory = Json.createBuilderFactory(null);
        JsonArrayBuilder jab = jbfactory.createArrayBuilder();
        Iterator<String> cit = sortedClasses.iterator();
        while( cit.hasNext() ){
            JsonObjectBuilder job = jbfactory.createObjectBuilder();
            String classinfo = cit.next();
            String[] data = classinfo.split("  "); 
            if (data.length != 3 ){
                System.out.println("data is wrong?");
            }
            job.add("uri", data[2]);
            job.add("label", data[0]);
            job.add("number", data[1]);
            jab.add(job);
        }
        JsonArray ja = jab.build();
        out.print(ja);
    }

    /**
     * Handles the HTTP <code>POST</code> method.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Returns a short description of the servlet.
     *
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Short description";
    }// </editor-fold>

}
