/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biohackathon.SPARQLBuilder.OWL;


/**
 *
 * @author atsuko
 */

public class QueryPathGenerator {
    private String sparqlEndpoint = null;
    private RDFSchemaAnalyzerFactory factory = null;
    private RDFSchemaAnalyzer analyzer = null;
    private OWLClassGraph graph;
    
    private static final String CDIR = "cdata";
    
    /*
    public static void main(String[] args){
        // For Test
        //String sp = "http://data.allie.dbcls.jp/sparql";
        //String sc = "http://purl.org/allie/ontology/201108#ShortForm";
        //String ec = "http://purl.org/allie/ontology/201108#LongForm";

        String sp = "http://www.ebi.ac.uk/rdf/services/chembl/sparql";
        String sc = "http://rdf.ebi.ac.uk/terms/chembl#Enzyme";
        String ec = "http://rdf.ebi.ac.uk/terms/chembl#Activity";

        //String sp = "http://www.ebi.ac.uk/rdf/services/biosamples/sparql";
        //String sc = "http://rdf.ebi.ac.uk/terms/biosd/Sample";
        //String ec = "http://purl.obolibrary.org/obo/NCBITaxon_7955";
        //String sp = "http://www.ebi.ac.uk/rdf/services/biosamples/sparql";
        //String sc = "http://rdf.ebi.ac.uk/terms/biosd/Sample";
        //String ec = "http://purl.obolibrary.org/obo/NCBITaxon_7955";
        //String sp = "http://lsd.dbcls.jp/sparql";
        //String sc = "http://purl.jp/bio/10/lsd/ontology/201209#EnglishCode";
        //String ec = "http://purl.jp/bio/10/lsd/ontology/201209#JapaneseCode";
        //QueryPathGenerator qpg = new QueryPathGenerator(sp, "c:\\cdata");
        QueryPathGenerator qpg1 = new QueryPathGenerator(sp, "cdata/");
        //qpg1.testOWLClassGraph();
        //SClass[] cl = qpg.getClasses(null);
    }*/
    
    public QueryPathGenerator(){
        factory = new RDFSchemaAnalyzerFactory(CDIR);
    }
    
    public QueryPathGenerator(String sparqlEndpoint){
        factory = new RDFSchemaAnalyzerFactory(CDIR);
        setSPARQLendpoint(sparqlEndpoint);
        setOWLClassGraph();
    }

    public QueryPathGenerator(String sparqlEndpoint, String crawlFileName){
        factory = new RDFSchemaAnalyzerFactory(crawlFileName);
        setSPARQLendpoint(sparqlEndpoint);
        setOWLClassGraph();
    }
    
    public SClass[] getClasses(String keyword){
        String[] keywords = null;
        if ( keyword != null ){
            if ( keyword.length() != 0 ){
                keywords = new String[1];
                keywords[0] = keyword;
            }
        }
        try {
            return analyzer.getOWLClasses(null, keywords, null, true);
        }catch(Exception e){
            System.err.println(e);
            return null;
        }
    } 
    
    public Path[] getPaths(String startClass, String endClass, boolean countLink){
        if ( graph == null ){
            setOWLClassGraph();
        }
        graph.setPartClassGraph(analyzer, startClass);
        return graph.getPaths(startClass, endClass);
        //return graph.getPaths(startClass, endClass, analyzer);
        //return graph.getPaths_old(analyzer, true, startClass, endClass);
    }
    
    public void setSPARQLendpoint(String sparqlEndpoint){
        this.sparqlEndpoint = sparqlEndpoint;
        setAnalyzer();
    }
    
    public RDFSchemaAnalyzerFactory getFactory(){
        return factory;
    }

    private void setAnalyzer(){
        try {
            analyzer = factory.create(sparqlEndpoint);
        } catch (Exception e) {
            System.err.println(e);
        }
    }
    
    public static String getClassLabelfromList(String classURI, SClass[] classes){
        if ( classURI == null ){
                    return "";
        }
        SClass sclass = null;
        for ( int i = 0 ; i < classes.length; i++ ){
            if ( classURI.equals(classes[i].getClassURI()) ){
                return getClassLabelfromClass(classes[i]);
            }                    
        }
        return "";
    }
    
    public static String getClassLabelfromClass(SClass sclass){
        Label[] labels = sclass.getLabels();
        for ( int i = 0 ; i < labels.length; i++ ){
            if ( labels[i].getLanguage() == null ){
                return labels[i].getLabel();
            }else if ( labels[i].getLanguage().equals("en") ){
                return labels[i].getLabel();
            }
        }
        String[] url = sclass.getClassURI().split("/");
        String tmplabel = url[url.length-1];
        String[] tmplabel2 = tmplabel.split("#");
        String label = tmplabel2[tmplabel2.length-1];
        return label;
    }
    
    private void setOWLClassGraph(){
        graph = new OWLClassGraph(analyzer); 
    }
    
    public OWLClassGraph getOWLClassGraph(){
        if ( graph == null ){
            graph = new OWLClassGraph(analyzer);             
        }
        return graph;
    }
}
