$(function(){

	scrolldiv();

	loadStartClass();


	$('#searchstart').keypress(function(e) {
		if ( e.which == 13 ) {
			return false;
		}
	});
	$('#searchstart').keyup(function(e) {
		search();
	});
	$('#searchend').keypress(function(e) {
		if ( e.which == 13 ) {
			return false;
		}
	});
	$('#searchend').keyup(function(e) {
		search();
	});
});

function scrolldiv(){
	if(($('div.startclass').height() + $('#searchstart').height()) > $('div.left').height()){
		$('div.left').css('overflow-y', 'scroll');
	}else{
		$('div.left').css('overflow-y', 'hidden');
	}
	if(($('div.endclass').height() + $('#searchend').height()) > $('div.right').height()){
		$('div.right').css('overflow-y', 'scroll');
	}else{
		$('div.right').css('overflow-y', 'hidden');
	}
}

function loadStartClass(){
	var url = "http://www.sparqlbuilder.org/api/clist?ep=" + encodeURIComponent("http://www.ebi.ac.uk/rdf/services/reactome/sparql");
	$.ajax({
		type : "GET",
		url : url,
		success : function(data) {
			var list = eval(data);
			$('div.startclass').empty();

			var startclasstable = $('<table>');

			for (var i = 0; i < list.length; ++i) {
				startclasstable.append('<tr><td class="startclasscell"><span class="endpointuri" title="http://www.ebi.ac.uk/rdf/services/reactome/sparql"></span><span class="startclassuri" title="' + list[i]['uri'] + '">' + list[i]['label'] + ' (' + list[i]['number'] + ')' + '</span></td></tr>');
			}

			$('div.startclass').append(startclasstable);

			requestEndClass();
			scrolldiv();
		}
	});
}

function requestEndClass(){
	$('.startclasscell').each(function(){
		$(this).unbind('click');
		$(this).click(function(){
			$('.endclass').empty();
			$('.endclass').append('<img src="images/ajax-loader.gif">');
			var ep = $(this).children('.endpointuri').attr('title');
			var sc = $(this).children('.startclassuri').attr('title');
			var url = "http://www.sparqlbuilder.org/api/clist?ep=" + encodeURIComponent(ep) + '&class=' + encodeURIComponent(sc);
			$.ajax({
				type : "GET",
				url : url,
				success : function(data) {
					var list = eval(data);
					$('.endclass').empty();
					var endclasstable = $('<table>');

					for (var i = 0; i < list.length; ++i) {
						endclasstable.append('<tr><td class="endclasscell"><span class="endpointuri" title="' + ep + '"></span><span class="startclassuri" title="' + sc + '"></span><span class="endclassuri" title="' + list[i]['uri'] + '">' + list[i]['label'] + ' (' + list[i]['number'] + ')' + '</span></td></tr>');
					}

					$('.endclass').append(endclasstable);

					requestSPARQLBuilder();
				}
			});
		});
	});
}

function requestSPARQLBuilder(){
	$('.endclasscell').each(function(){
		$(this).unbind('click');
		$(this).click(function(){
			var ep = $(this).children('.endpointuri').attr('title');
			var sc = $(this).children('.startclassuri').attr('title');
			var ec = $(this).children('.endclassuri').attr('title');
			var url = "http://www.sparqlbuilder.org/?ep=" + encodeURIComponent(ep) + '&st=' + encodeURIComponent(sc) + '&en=' + encodeURIComponent(ec);

			window.open(url);
		});
	})
}

function search(){
	if($('#searchstart').val() == ''){
		$('.startclasscell').parent().removeClass('nohit');
	}else{
		var keyword = $('#searchstart').val().toLowerCase();
		$('.startclasscell').each(function(){
			var label = $(this).children('.startclassuri').text().toLowerCase();
			if(label.indexOf(keyword) != -1){
				$(this).parent().removeClass('nohit');
			}else{
				$(this).parent().addClass('nohit');
			}
		});
	}
	if($('#searchend').val() == ''){
		$('.endclasscell').parent().removeClass('nohit');
	}else{
		var keyword = $('#searchend').val().toLowerCase();
		$('.endclasscell').each(function(){
			var label = $(this).children('.endclassuri').text().toLowerCase();
			if(label.indexOf(keyword) != -1){
				$(this).parent().removeClass('nohit');
			}else{
				$(this).parent().addClass('nohit');
			}
		});
	}

	setTimeout('scrolldiv()',30);
}