package org.biohackathon.SPARQLBuilder.OWL;

/**
 * クラスへ、あるいはクラスからの1ステップリンクを記述する
 * @author Norio KOBAYASHI
 * @since 28.01.2014
 * @version 29.01.2014
 */
public class ClassLink {

	private String propertyURI = null;
	private String linkedClassURI = null;
	private Direction direction = null;
	private int numOfLinks = 0;

	/**
	 * プロパティURI、リンク先（元）クラス、リンクの向きを与える構成子
	 * 
	 * @param propertyURI　プロパティのURI
	 * @param linkedClassURI　リンクの主語、、あるいはリンクの目的語となっているクラスのURI
	 * @param direction プロパティの向き、linkedClassURIのクラスがリンク先になっているときはDirection.forward,リンク元になっているときはDirection.reverse, それら両方の時はDirection.bothを指定する 
	 * @param numOfLinks 当該プロパティで両端クラスのインスタンス同士をつないでいるリンク数（トリプル数）
	 * @throws Exception
	 * @since 28.01.2014
	 */
	public ClassLink(String propertyURI, String linkedClassURI, Direction direction, int numLinks){
		this.propertyURI = propertyURI;
		this.linkedClassURI = linkedClassURI;
		this.direction = direction;
		this.numOfLinks = numLinks;
	}
	
	
	public int getNumOfLinks() {
		return numOfLinks;
	}




	public void setNumOfLinks(int numOfLinks) {
		this.numOfLinks = numOfLinks;
	}




	/**
	 * 文字列表記を取得する
	 * 
	 * @since 28.01.2014
	 */
	public String toString(){
		StringBuffer sb = new StringBuffer();
		sb.append(propertyURI);
		if( direction == Direction.forward ){
			sb.append(" --> ");
		}else{
			if( direction == Direction.reverse ){
			sb.append(" <-- ");
			}else{
				sb.append(" <-> ");
			}
		}
		sb.append(linkedClassURI);
		sb.append(" [");
		sb.append(numOfLinks);
		sb.append("]");
		return sb.toString();
	}
	
	public String getPropertyURI() {
		return propertyURI;
	}
	public void setPropertyURI(String propertyURI) {
		this.propertyURI = propertyURI;
	}
	public String getLinkedClassURI() {
		return linkedClassURI;
	}
	public void setLinkedClassURI(String linkedClassURI) {
		this.linkedClassURI = linkedClassURI;
	}
	public Direction getDirection() {
		return direction;
	}
	public void setDirection(Direction direction) {
		this.direction = direction;
	}
		
	// private String[] propertyDomainClassURIs = null;
	// private String[] propertyRangeClassURIs = null;

		
}
