/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biohackathon.SPARQLBuilder.www;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.biohackathon.SPARQLBuilder.OWL.*;

/**
 *
 * @author atsuko
 */
@WebServlet(name = "PLServlet", urlPatterns = {"/plist"})
public class PLServlet extends HttpServlet {

    private static final String FILENAME = "cdata/";    
    
    /**
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code>
     * methods.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        try (PrintWriter out = response.getWriter()) {
            /* TODO output your page here. You may use following sample code. */
            out.println("<!DOCTYPE html>");
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Servlet PLServlet</title>");            
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Servlet PLServlet at " + request.getContextPath() + "</h1>");
            out.println("</body>");
            out.println("</html>");
        }
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /**
     * Handles the HTTP <code>GET</code> method.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        //processRequest(request, response);
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "GET");
        response.setHeader("Access-Control-Allow-Headers", request.getHeader("Access-Control-Request-Headers"));
        response.setHeader("Access-Control-Max-Age", "-1");
	PrintWriter out = response.getWriter();
        String ep = request.getParameter("ep");
        String st = request.getParameter("startclass");
        String en = request.getParameter("endclass");
        //String ask = request.getParameter("ask");
        
        // String
        String uri = request.getQueryString();
        System.out.println(uri);
        
        HttpSession session = request.getSession();
        QueryPathGenerator qpg = (QueryPathGenerator)session.getAttribute("qpg");
        if ( qpg == null ){
            qpg = new QueryPathGenerator();
        }
        SClass[] classes = qpg.getClasses(null);
        qpg.setClassLabels(classes);
        
        Path[] paths = null;
        paths = qpg.getPaths(st, en);            
        if ( paths == null ){
            out.print(" ");
        }else{
            String jsonstr = "[";
  	    for(int i = 0; i< paths.length; i++){
	        if (i > 0 && paths[i] != null){
	            jsonstr += ",";
	        }
                if ( paths[i] == null ){
                    continue;
                }
                jsonstr += paths[i].toJSONString4(qpg);
	    }
	    jsonstr += "]";
        // For debug
        /*
        System.out.println("JSON:");
        System.out.println(jsonstr);
        */
            out.print(jsonstr);
        }
    }

    /**
     * Handles the HTTP <code>POST</code> method.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Returns a short description of the servlet.
     *
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Short description";
    }// </editor-fold>

}
