package org.biohackathon.SPARQLBuilder.endpointMetadata;

import java.io.File;
import java.util.HashMap;
import java.util.Set;

import jp.riken.accc.db.sparqlBuilderMetadata.crawler.dataStructure.sparql.crawler.CrawledMetadata;
import jp.riken.accc.db.sparqlBuilderMetadata.crawler.dataStructure.sparql.crawler.CrawledMetadataFileReader;

public class MetadataManager {

	HashMap<String,CrawledMetadata> metadataTable = null;
	
	/*
	public static void main(String[] args) throws Exception{
		String dirStr = "c:\\temp\\crawl";
		MetadataManager manager = new MetadataManager(dirStr);
		String[] uris = manager.getURIList();
		for(String uri: uris){
			System.out.println(uri);
			MetadataFile mFile = manager.getMetadataFile(uri);
			System.out.println(mFile.getStartDateTime().getTime().toString());
			System.out.println(mFile.getEndDateTime().getTime().toString());
		}
	}*/	

	public CrawledMetadata[] getCrawlerMetadataList(){
		return metadataTable.values().toArray(new CrawledMetadata[0]);
	}
	public CrawledMetadata getCrawledMetadata(String uri){
		return metadataTable.get(uri);
	}

	public String[] getURIList(){
		Set<String> keySet = metadataTable.keySet();
		return keySet.toArray(new String[0]);
	}
	
	
	public MetadataManager(String metadataDirStr) throws Exception {
		init(metadataDirStr);
	}
	
	
	public void init(String metadataDirStr) throws Exception{
		metadataTable = new HashMap<String,CrawledMetadata>();
		File metadataDir = new File(metadataDirStr);
		File[] files = null;
		if( metadataDir.exists() ){
			if( metadataDir.isFile()){
				files = new File[]{metadataDir};
			}else{
				if( metadataDir.isDirectory()){
					files = metadataDir.listFiles();
				}else{
					throw new Exception("Inernal File/Directory error: " + metadataDirStr);
				}
			}
		}else{
			throw new Exception("File/Directory not found: " + metadataDirStr);
		}
		for(File file: files){
			CrawledMetadata crawledMetadata = null;
			try{
				crawledMetadata = CrawledMetadataFileReader.readFile(file.getCanonicalPath());
				String uri = crawledMetadata.getEndpointURI();
				if( uri != null ){
					if( metadataTable.containsKey(uri)){
						CrawledMetadata tempMF = metadataTable.get(uri);
						if(tempMF.getDefaultDataset().getCrawlLog().crawlEndTime.before(crawledMetadata.getDefaultDataset().getCrawlLog().crawlEndTime) ){
							metadataTable.remove(uri);
							metadataTable.put(uri,  crawledMetadata);
						}
					}else{
						metadataTable.put(uri, crawledMetadata);
					}
				}
			}catch(Exception ex){
				// WARNING
				System.out.println("Invalid metadata file: " + file.getAbsolutePath());
				ex.printStackTrace();
			}
		}
	}
}
