package org.biohackathon.SPARQLBuilder.OWL;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import org.biohackathon.SPARQLBuilder.endpointMetadata.MetadataFile;
import org.biohackathon.SPARQLBuilder.endpointMetadata.MetadataManager;

import jp.riken.accc.db.sparqlBuilderMetadata.crawler.dataStructure.sparql.JenaModelGenerator;
import jp.riken.accc.db.sparqlBuilderMetadata.crawler.dataStructure.sparql.crawler.CrawledMetadata;

public class RDFSchemaAnalyzerFactory {

	private MetadataManager metadataManager = null;
//	private Map<String, String> acquiredRDFFiles = null;
	private static final String FILENAME = "C:\\cdata";
        
        public RDFSchemaAnalyzerFactory(String fileName){
            try{
            	metadataManager = new MetadataManager(fileName);
//            	setAcqiredRDFFiles(new File(fileName));
            }catch(Exception e){
                System.err.println(e);
            }
        }

        public RDFSchemaAnalyzerFactory(){
            try{
            	metadataManager = new MetadataManager(FILENAME);
//            	setAcqiredRDFFiles(new File(FILENAME));
            }catch(Exception e){
                System.err.println(e);
            }
        }

//	private void setAcqiredRDFFiles(String dirFile) throws Exception{
//		setAcqiredRDFFiles(new File(dirFile));
//	}
	
//	private void setAcqiredRDFFiles(File data) throws Exception{
//		StructureCrawler sc = new StructureCrawler(data);
//		acquiredRDFFiles = sc.getAcquiredStructureFiles();
//	}

	public String[] getEndpointURIList(){
		return metadataManager.getURIList();
	}

	public CrawledMetadata[] getMetadataFiles(){
		return metadataManager.getCrawlerMetadataList();
	}
	

	public RDFSchemaAnalyzer create(String uri) throws Exception{
		CrawledMetadata crawledMetadata = metadataManager.getCrawledMetadata(uri);
		if( crawledMetadata == null ){
			return new EndpointAnalyzer(uri);
		}else{
			return new AcquiredStructureAnalyzer(crawledMetadata);
		}
	}
}
