package org.biohackathon.SPARQLBuilder.OWL;

import java.util.List;

/**
 * クエリを生成するための機能を提供する核インターフェイス
 * @author YAMAGUCHI
 * @author GO
 * @author KOZAKI
 * @author KOBAYASHI
 * @since 28.01.2014
 * @version 29.01.2014
 */
public interface RDFSchemaAnalyzer {
	/**
	 * 明示的にRDFで書かれているクラスを取得する
	 * <p>
	 * キーワードにヒットするラベルを持つクラス（rdfs:Class）をすべて返す
	 * <br>
	 * </p>
	 * 
	 * @param keyword （nullや空文字は不可）
	 * @param countInstances クラスに属しているインスタンスの数を数える場合はtrueを与える
	 * @return クラスURIの配列
	 * @throws Exception
	 * @since 28.01.2014
	 */
	public SClass[] getOWLClasses(String[] keyword, String language) throws Exception;
	
	public List<SClass> getOWLClassList(String[] keyword, String language) throws Exception;

    public SClass[] listClasses() throws Exception;
	
    

	/**
	 *　指定されたクラスを起点とし、明示的に記述されているOWLのproperty制約を調べ、そのproperty制約で
	 * 関連づけられているクラスを網羅的に取得する
	 * 
	 * @param originClass 起点となるクラスのURI　（null不可）
	 * @param limit 解として返されるClassLink配列の長さの上限値を指定する。(上限値を設定しない場合は0以下の値を指定する)
	 * @return ClassLinkの配列。ここには、取得されたクラスと関係づけられているプロパティ、関係の向きが含まれる。
	 * @throws Exception
	 * @since 28.01.2014
	 */
	public ClassLink[] getNextClass(String originClass, int limit) throws Exception;

	
	public LabelMap[] getLabels(String[] resourceURIs, String language) throws Exception;

}
