package org.biohackathon.SPARQLBuilder.OWL;

import java.util.HashSet;

public class SClass {

	private String classURI;
	private int numOfInstances;
	private HashSet<Label> labels;
	private String endpointURI = null;
	private String graphURI = null;

	/**
	 * インスタンスのURIとそのインスタンスが属しているすべてのクラスを与える構成子
	 * 
	 * @param instanceURI
	 *            　インスタンスのURI
	 * @param classURIs
	 *            　当該インスタンスが属しているすべてのクラスのURIの配列
	 * @throws Exception
	 * @since 28.01.2014
	 */
	public SClass(String classURI, Label[] labels, int numOfInstances, String endpointURI, String graphURI) {
		this.classURI = classURI;
		this.numOfInstances = numOfInstances;
		setLabels(labels);
		this.endpointURI = endpointURI;
		this.graphURI = graphURI;
	}

	/**
	 * 文字列表記を取得する
	 * 
	 * @since 28.01.2014
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(classURI);
		sb.append("[");
		boolean f = false;
		if (labels != null) {
			for (Label label : labels) {
				if (f) {
					sb.append(", ");
				}
				f = true;
				sb.append(label.toString());
			}
		}
		sb.append("], ");
		sb.append(numOfInstances);
		return sb.toString();
	}

	public final String getClassURI() {
		return classURI;
	}

	public final void setClassURI(String classURI) {
		this.classURI = classURI;
	}

	public final int getNumOfInstances() {
		return numOfInstances;
	}

	public final void setNumOfInstances(int numOfInstances) {
		this.numOfInstances = numOfInstances;
	}

	public final Label[] getLabels() {
		return labels.toArray(new Label[0]);
	}

	public final void setLabels(Label[] labelArrays) {
		labels = new HashSet<Label>();
		if (labelArrays != null) {
			for (Label label : labelArrays) {
				labels.add(label);
			}
		}
	}

	public void addLabel(Label label) {
		labels.add(label);
	}

	public final String getEndpointURI() {
		return endpointURI;
	}

	public final void setEndpointURI(String endpointURI) {
		this.endpointURI = endpointURI;
	}

	public final String getGraphURI() {
		return graphURI;
	}

	public final void setGraphURI(String graphURI) {
		this.graphURI = graphURI;
	}

	
	
}
