package org.biohackathon.SPARQLBuilder.OWL;

import org.biohackathon.SPARQLBuilder.endpointMetadata.MetadataManager;
import jp.riken.accc.db.sparqlBuilderMetadata.crawler.dataStructure.sparql.crawler.CrawledMetadata;


public class RDFSchemaAnalyzerFactory {

	private MetadataManager metadataManager = null;
	private static final String FILENAME = "C:\\home\\kobayashi";
     
	
	public static void main(String[] args) throws Exception{
		RDFSchemaAnalyzerFactory factory = new RDFSchemaAnalyzerFactory();
		RDFSchemaAnalyzer analyzer = factory.create();
		SClass[] sClassList = analyzer.getOWLClasses(null, null);
		for(SClass sClass: sClassList){
			System.out.println(sClass.getClassURI());
		}
	}
	
        public RDFSchemaAnalyzerFactory(String fileName){
            try{
            	metadataManager = new MetadataManager(fileName);
            }catch(Exception e){
                System.err.println(e);
            }
        }

        public RDFSchemaAnalyzerFactory(){
            try{
            	metadataManager = new MetadataManager(FILENAME);
            }catch(Exception e){
                System.err.println(e);
            }
        }

	

	public String[] getEndpointURIList(){
		return metadataManager.getURIList();
	}

	public CrawledMetadata[] getMetadataFiles(){
		return metadataManager.getCrawlerMetadataList();
	}
	

	public RDFSchemaAnalyzer create() throws Exception{
			return new AcquiredStructureAnalyzer(metadataManager);
	}
}
