/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biohackathon.SPARQLBuilder.OWL;

/**
 *
 * @author atsuko
 */
import java.util.*;


public class LabeledMultiDigraph {
    //List<List<LabeledEdge>> adjlist;
    List<Map<Integer,List<LabeledEdge>>> labelededges;
    List<String> labels;
    HashMap<String,Integer> labelednodes;
    //List<Map<Integer,List<LabeledEdge>>> gadjlist; // grouped adj list: node, node-edge list
    
    public class LabeledEdge{
        boolean direction;
        Object label;
        
        public LabeledEdge(boolean dir, Object label){
            this.direction = dir;
            this.label = label;
        }
        
        public Object getLabel(){
            return label;
        }
    }
    
    public LabeledMultiDigraph(){
        //adjlist = new ArrayList<List<LabeledEdge>>();
        labelededges = new ArrayList<Map<Integer,List<LabeledEdge>>>();
        labels = new LinkedList<String>();
        labelednodes = new HashMap<String, Integer>();
        //gadjlist = new ArrayList<Map<Integer,List<LabeledEdge>>>();
    }
    
    public void addNode(String label){
        labelednodes.put(label, labels.size());
        labels.add(label);
        //adjlist.add(new LinkedList<LabeledEdge>());
        //gadjlist.add(new HashMap<Integer, List<LabeledEdge>>());
        labelededges.add(new HashMap<Integer, List<LabeledEdge>>());
    }
    
    public void addEdge(Integer node1, Integer node2, Object elabel){ // node 1 -> node2
        if ( labels.size() < node1 || labels.size() < node2 ){
            System.err.println("Error for Edge Addition: No Node for the Edge");
            return;
        }
        
        //LabeledEdge edge = new LabeledEdge(node2,elabel);
        //adjlist.get(node1).add(edge);
        List<LabeledEdge> edgesf = labelededges.get(node1).get(node2);
        if ( edgesf == null ){
            edgesf = new LinkedList<LabeledEdge>();
            labelededges.get(node1).put(node2, edgesf);
        }
        edgesf.add(new LabeledEdge(true, elabel));
        
        List<LabeledEdge> edgesr = labelededges.get(node2).get(node1);
        if ( edgesr == null ){
            edgesr = new LinkedList<LabeledEdge>();
            labelededges.get(node2).put(node1, edgesr);
        }
        edgesr.add(new LabeledEdge(false, elabel));
    }
}
