/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

package org.biohackathon.SPARQLBuilder.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.*;
import javax.json.*;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.biohackathon.SPARQLBuilder.OWL.*;

/**
 *
 * @author atsuko
 */
@WebServlet(name = "CLServlet", urlPatterns = {"/clist"})
public class CLServlet extends HttpServlet {

    private static final String FILENAME = "cdata/";
    
    /**
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code>
     * methods.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        try (PrintWriter out = response.getWriter()) {
            /* TODO output your page here. You may use following sample code. */
            out.println("<!DOCTYPE html>");
            out.println("<html>");
            out.println("<head>");
            out.println("<title>Servlet CLServlet</title>");            
            out.println("</head>");
            out.println("<body>");
            out.println("<h1>Servlet CLServlet at " + request.getContextPath() + "</h1>");
            out.println("</body>");
            out.println("</html>");
        }
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /**
     * Handles the HTTP <code>GET</code> method.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        //processRequest(request, response);
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", "GET");
        response.setHeader("Access-Control-Allow-Headers", request.getHeader("Access-Control-Request-Headers"));
        response.setHeader("Access-Control-Max-Age", "-1");     
	PrintWriter out = response.getWriter();
        String ep = request.getParameter("ep");
        
        HttpSession session = request.getSession();
        QueryPathGenerator qpg = (QueryPathGenerator)session.getAttribute("qpg");
        SortedSet<String> sortedClasses = null;
                
        if ( qpg == null ){
            qpg = new QueryPathGenerator();
        }
        if ( ep == null ){
            JsonBuilderFactory jbfactory = Json.createBuilderFactory(null);

            String[] eplist = qpg.getFactory().getEndpointURIList();
            TreeSet<String> classes = new TreeSet<String>();
            for ( int i = 0; i < eplist.length; i++ ){
                try{
                    qpg.setSPARQLendpoint(eplist[i]);
                    SClass[] cls = qpg.getClasses(null);
                    qpg.setClassLabels(cls); // HENKO TODO
                    for (int j = 0; j < cls.length; j++ ){
                        classes.add(qpg.getClassLabel(cls[j].getClassURI()).concat("\t")
                                .concat(cls[j].getClassURI()).concat("\t")
                                .concat(new Integer(cls[j].getNumOfInstances()).toString())
                                .concat("\t").concat(eplist[i]));
                    }
                }catch(Exception e){
                    e.printStackTrace();
                    System.err.println(e);
                }
            }
            JsonArray ja = getJsonArrayFromClasses(jbfactory, classes);
            out.print(ja);
            return;
        }
        String classURI = request.getParameter("class");
        qpg.setSPARQLendpoint(ep);
        SClass[] classes = null;
        if ( classURI != null ){
            qpg.setOWLClassGraph(classURI);
            classes = qpg.getReachableClasses();
        }else{
            classes = qpg.getClasses(null);
        }
        sortedClasses = qpg.getSortedClasses(classes);
        
        JsonBuilderFactory jbfactory = Json.createBuilderFactory(null);
        JsonArray ja = getJsonArrayFromSortedClasses(jbfactory, sortedClasses, ep);
        out.print(ja);
    }

    /**
     * Handles the HTTP <code>POST</code> method.
     *
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /**
     * Returns a short description of the servlet.
     *
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Short description";
    }// </editor-fold>

    
    private JsonArray getJsonArrayFromSortedClasses(JsonBuilderFactory jbfactory, 
             SortedSet<String> sortedClasses, String ep){
        JsonArrayBuilder jab = jbfactory.createArrayBuilder();
        Iterator<String> cit = sortedClasses.iterator();
        List<String> tmpclasses = new LinkedList<String>();
        JsonObjectBuilder job = jbfactory.createObjectBuilder();
        while( cit.hasNext() ){
            String classinfo = cit.next();
            String[] data = classinfo.split("\t"); 
            if (data.length != 3 ){
                System.out.println("data is wrong?");
            }
            if (data[0].matches("^[0-9]*$")){
                tmpclasses.add(classinfo);
            }else{
                job.add("ep", ep);
                job.add("uri", data[2]);
                job.add("label", data[0]);
                job.add("number", data[1]);
                jab.add(job);
            }
        }
        cit = tmpclasses.iterator();
        while( cit.hasNext() ){
            String classinfo = cit.next();
            String[] data = classinfo.split("\t"); 
            if (data.length != 3 ){
                System.out.println("data is wrong?");
            }
            job.add("ep", ep);
            job.add("uri", data[2]);
            job.add("label", data[0]);
            job.add("number", data[1]);
            jab.add(job);
        }       
        JsonArray ja = jab.build();
        return ja;
    }

    private JsonArray getJsonArrayFromClasses(JsonBuilderFactory jbfactory, TreeSet<String> cl){
        JsonArrayBuilder jab = jbfactory.createArrayBuilder();
        JsonObjectBuilder job = jbfactory.createObjectBuilder();
        Iterator<String> cit = cl.iterator();
        
        while( cit.hasNext() ){
            String classinfo = cit.next();
            String[] data = classinfo.split("\t"); 
            if (data.length != 4 ){
                System.out.println("data is wrong?"); // KOKO
            }else{
                job.add("ep", data[3]);
                job.add("uri", data[1]);
                job.add("label", data[0]);
                job.add("number", data[2]);
                jab.add(job);
            }
        }
        JsonArray ja = jab.build();
        return ja;
    }    
}

