/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biohackathon.SPARQLBuilder.OWL;

/**
 *
 * @author atsuko
 */
import java.util.*;

public class OWLClassGraph extends LabeledMultiDigraph{
    String startClass;
    String endClass;
    int startNode;
    int endNode;
    int nsteps;
    int limit;
    
    List<OWLEdge> allOWLEdge; 
        
    public class OWLEdge{
        String startClass;
        ClassLink classLink;
        public OWLEdge(String startClass, ClassLink classLink){
           this.startClass = startClass; 
           this.classLink = classLink;
        }
    }
    
    public class LinkAndPath{
        ClassLink classLink;
        List<ClassLink> path;
        public LinkAndPath(ClassLink classLink, List<ClassLink> path){
           this.classLink = classLink;
           this.path = path;
        }
    }
    
    public OWLClassGraph(String p_startClass, String p_endClass){
        super();
        startClass = p_startClass;
        adjlist.add(new LinkedList<LabeledEdge>());
        labels.add(startClass);
        endClass = p_endClass;
        labels.add(endClass);
        nsteps = 3;
        limit = 100;
        allOWLEdge= new LinkedList<OWLEdge>();
    }
    
    public void generateGraph(){
        // atode
    }
    
    public Path[] getPaths(OWLQueryBuilderImpl qb){
        List<List<ClassLink>> paths = searchPathsFromOWL(qb);
        Path[] patharray = new Path[paths.size()];
        ListIterator<List<ClassLink>> pit = paths.listIterator();
        int i = 0;
        while ( pit.hasNext() ){
            patharray[i].setStartClass(startClass);
            List<ClassLink> path = pit.next();
            path.remove(0);
            patharray[i].setClassLinks(path);
            i++;
        }
        return patharray;
    }
    
    private List<List<ClassLink>> searchPathsFromOWL(OWLQueryBuilderImpl qb){
        List<List<ClassLink>> paths = new ArrayList<List<ClassLink>>();
        ClassLink crrLink = new ClassLink(null,startClass,Direction.both);
        List<LinkAndPath> lp = new LinkedList<LinkAndPath>();
        lp.add(new LinkAndPath(crrLink, new LinkedList<ClassLink>()));
        try{
          for ( int i = 0; i < nsteps; i++ ){
              ListIterator<LinkAndPath> lit = lp.listIterator();
              List<LinkAndPath> nextlp = new LinkedList<LinkAndPath>();
              while ( lit.hasNext() ){
                  LinkAndPath crrlp = lit.next();
                  if ( crrlp.classLink.getLinkedClassURI().equals(endClass) ){ continue; }
                  ClassLink[] classLinks = qb.getNextClass(null, crrlp.classLink.getLinkedClassURI(), limit);
                  for ( int j = 0 ; j < classLinks.length; j++ ){
                      List<ClassLink> crrpath = new LinkedList<ClassLink>(crrlp.path);
                      crrpath.add(classLinks[j]);
                      if ( classLinks[j].getLinkedClassURI().equals(endClass) ){
                          paths.add(new LinkedList<ClassLink>(crrpath));
                      }
                      nextlp.add(new LinkAndPath(classLinks[j],crrpath));
                  }
              }
          }
        }catch(Exception e){ System.err.println(e);}
        return paths;
    }
}
