/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.biohackathon.SPARQLBuilder.OWL;

/**
 *
 * @author atsuko
 */
import java.util.*;

public class OWLClassGraph extends LabeledMultiDigraph{
    String startClass;
    String endClass;
    int nsteps;
    int limit;
        
    public class LinkAndPath{
        ClassLink classLink;
        List<ClassLink> path;
        public LinkAndPath(ClassLink classLink, List<ClassLink> path){
           this.classLink = classLink;
           this.path = path;
        }
    }
    
    public OWLClassGraph(String startClass, String endClass){
        super();
        this.startClass = startClass;
        addNode(startClass);
        this.endClass = endClass;
        addNode(endClass);
        nsteps = 2;
        limit = 1000;
    }
    
    public void generateGraph(List<List<ClassLink>> paths){
        ListIterator<List<ClassLink>> pit = paths.listIterator();
        while( pit.hasNext() ){
            List<ClassLink> cls = pit.next();
            String start = startClass;
            ListIterator<ClassLink> cit = cls.listIterator();
            while ( cit.hasNext() ){
                // KOKO
            }
        }
    }
    
    public Path[] getPaths(OWLQueryBuilderImpl qb, int mode, boolean countLink){
        List<List<ClassLink>> paths = searchPaths(qb, mode, countLink);
        Path[] patharray = new Path[paths.size()];
        ListIterator<List<ClassLink>> pit = paths.listIterator();
        int i = 0;
        while ( pit.hasNext() ){
            patharray[i] = new Path();
            patharray[i].setStartClass(startClass);
            List<ClassLink> path = pit.next();
            patharray[i].setClassLinks(path);
            ListIterator<ClassLink> cit = path.listIterator();
            int min = Integer.MAX_VALUE;
            while ( cit.hasNext() ){
                ClassLink cl = cit.next();
                if ( cl.getNumOfLinks() < min ){
                    min = cl.getNumOfLinks();
                }
            }
            patharray[i].setWidth(min);
            i++;
        }
        return patharray;
    }
    
    /*
    private List<List<ClassLink>> searchPathsFromOWL(OWLQueryBuilderImpl qb){
        return searchPathsEngine(qb, 0);
    }
    
    private List<List<ClassLink>> searchPathsFromInstances(OWLQueryBuilderImpl qb){
        return searchPathsEngine(qb, 1);
    }
    */
    
    private List<List<ClassLink>> searchPaths(OWLQueryBuilderImpl qb, int mode, boolean countLinks){
        List<List<ClassLink>> paths = new ArrayList<>();
        ClassLink crrLink = new ClassLink(null,startClass,Direction.both,0);
        List<LinkAndPath> lp = new LinkedList<>();
        lp.add(new LinkAndPath(crrLink, new LinkedList<ClassLink>()));
        try{
          for ( int i = 0; i < nsteps; i++ ){
              ListIterator<LinkAndPath> lit = lp.listIterator();
              List<LinkAndPath> nextlp = new LinkedList<>();
              while ( lit.hasNext() ){
                  LinkAndPath crrlp = lit.next();
                  if ( crrlp.classLink.getLinkedClassURI().equals(endClass) ){ continue; }
                  ClassLink[] classLinks = null;
                  // Mode
                  if ( mode == 0 ){
                      classLinks = qb.getNextClass(null, crrlp.classLink.getLinkedClassURI(), limit, countLinks);
                  }else if ( mode == 1 ){
                      classLinks = qb.getNextClassViaInstanceLink(null, crrlp.classLink.getLinkedClassURI(), limit);                      
                  }else{ System.err.println("Mode is not correct."); }
                  for ( int j = 0 ; j < classLinks.length; j++ ){
                      List<ClassLink> crrpath = new LinkedList<>(crrlp.path);
                      crrpath.add(classLinks[j]);
                      if ( classLinks[j].getLinkedClassURI().equals(endClass) ){
                          paths.add(new LinkedList<>(crrpath));
                      }
                      nextlp.add(new LinkAndPath(classLinks[j],crrpath));
                  }
              }
              lp = nextlp;
          }
        }catch(Exception e){ 
            System.err.println(e);
        }
        return paths;  
    }
}
