package org.biohackathon.SPARQLBuilder.OWL;

import java.util.List;

/**
 * 起点となるリソースから逐次??リンクで終点リソースまで接続される?つのパスを記述する
 * @author Yamaguchi
 * @since 28.01.2014
 * @version 29.01.2014
 */
public class Path{

	/**
	 * パスの起点となるクラスのURI
	 */
	private String startClass;

	/**
	 * パスの起点から終点に向かって逐次?つながるクラス間リンクのリス?
	 */
	private List<ClassLink> classLinks;
	
	public String getStartClass(){
		return startClass;
	}

/*	public String[] getProperties(){
		return properties;
	}

	public String[] getObjectClasses(){
		return objectClasses;
	}

	public Direction[] getDirections(){
		return directions;
	}
	*/
	public List<ClassLink> getClassLinks(){
		return classLinks;
	}	
	
	public Path(){}
	
	public Path(String startClass, List<ClassLink> classLinks){
		this.startClass = startClass;
		this.classLinks = classLinks;
	}
	
	public void setStartClass(String startClass){
		this.startClass = startClass;
	}

	public void setClassLinks(List<ClassLink> classLinks){
		this.classLinks = classLinks;
	}
	
}