package hozo.sparql.gui;

import hozo.maptool.MapFactory;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

import javax.swing.*;

import hozo.sparql.EndpointSettingsManager;
import hozo.sparql.SparqlQueryListener;

import org.biohackathon.SPARQLBuilder.OWL.ClassLink;
import org.biohackathon.SPARQLBuilder.OWL.Direction;
import org.biohackathon.SPARQLBuilder.OWL.Instance;
import org.biohackathon.SPARQLBuilder.OWL.OWLQueryBuilder;
import org.biohackathon.SPARQLBuilder.OWL.OWLQueryBuilderImpl;
import org.biohackathon.SPARQLBuilder.OWL.Path;
import org.biohackathon.SPARQLBuilder.OWL.SClass;



public class SparqlBuilderPanel extends JPanel{
	
	JTextField jtf_start_class;
	JTextField jtf_end_class;
	JTextField jtf_mode;
	JCheckBox jcb_count_ins;
	
	JTextArea jta_query;
	MapFactory map;
	SparqlSearchPanel search_panel;
	OWLQueryBuilderImpl builder;

//	public SparqlBuilderPanel(SparqlAccessorForm parent) {
//		super(parent);
//		initialize();
//		this.parent = parent;
//	}
	
	public OWLQueryBuilderImpl getOWLQueryBuilderImpl(){
		makeOWLQueryBuilderImpl();
		
		return builder;
	}

/*	SparqlBuilderPanel(SparqlAccessorForm sparqlAccessorForm){
		super();
		
		this.setLayout(new BorderLayout());
		JPanel jp_top = new JPanel();
		jtf_start_class = new JTextField("http://dbpedia.org/ontology/Artist");
		jp_top.add(new JLabel("Start Class:"));
		jp_top.add(jtf_start_class);
		JButton jb_start =  new JButton("Select");
		jp_top.add(jb_start);

		jtf_end_class = new JTextField("http://dbpedia.org/ontology/Award");
		jp_top.add(new JLabel("End Class:"));
		jp_top.add(jtf_end_class);
		JButton jb_end =  new JButton("Select");
		jp_top.add(jb_end);

		JButton  jb_get_path = new JButton("Get Path");
		jp_top.add(jb_get_path);
		
		map = new MapFactory();
		map.setSPARQLbuilder(this);

		
		jb_get_path.addActionListener(new ActionListener() {
					
			@Override
			public void actionPerformed(ActionEvent e) {
				System.out.println("getPaths:::>>>>"+jtf_start_class.getText()
						+"<===>"+jtf_end_class.getText());
			     //map.loadPathList(map.getDummyPathList());		
				
				try {
					System.out.println("getPaths:::>>>>"+jtf_start_class.getText()
							+"<===>"+jtf_end_class.getText());
					OWLQueryBuilderImpl builder = makeOWLQueryBuilderImpl();
					Path[] path = builder.getPaths(jtf_start_class.getText(), jtf_end_class.getText());
					System.out.println("RESULT:::>>>>"+path.length);
					
					map.loadPathList(path);		
					//jta_query.setText(createSPARQL(path[0]));
					
				} catch (Exception e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
				
				
				
			}
		});
		
		this.add(jp_top, BorderLayout.NORTH);
		jta_query = new JTextArea();
		this.add(new JScrollPane(jta_query), BorderLayout.CENTER);
		JPanel jp_bottom = new JPanel();
		jp_bottom.add(new JButton("make query"));
		this.add(jp_bottom, BorderLayout.SOUTH);
	}*/


	SparqlBuilderPanel(SparqlSearchPanel panel){
		super();
		this.search_panel = panel;
		
		this.setLayout(new GridLayout(3,1));
		JPanel jp1 = new JPanel();
		jp1.setLayout(new BorderLayout());
		
		jtf_start_class = new JTextField(40);
		//jtf_start_class.setText("http://dbpedia.org/ontology/Artist");
		jtf_start_class.setText("http://purl.jp/bio/10/lsd/ontology/201209#EnglishCode");
		jp1.add(new JLabel("Start Class:"),BorderLayout.WEST);
		jp1.add(jtf_start_class,BorderLayout.CENTER);
		JButton jb_start =  new JButton("Select");
		jp1.add(jb_start,BorderLayout.EAST);
		jb_start.addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent arg0) {
				// TODO Auto-generated method stub
				System.out.println("jb_start action");
				searchClass(jtf_start_class.getText());
				String classURI = searchClass(jtf_start_class.getText());
				jtf_start_class.setText(classURI);
			}
			
		});
		
		JPanel jp2 = new JPanel();
		jp2.setLayout(new BorderLayout());
		jtf_end_class = new JTextField(40);
	    //jtf_end_class.setText("http://dbpedia.org/ontology/Award");
		jtf_end_class.setText("http://purl.jp/bio/10/lsd/ontology/201209#JapaneseEntry");

		jp2.add(new JLabel("End Class:"),BorderLayout.WEST);
		jp2.add(jtf_end_class,BorderLayout.CENTER);
		JButton jb_end =  new JButton("Select");
		jb_end.addActionListener(new ActionListener(){

			@Override
			public void actionPerformed(ActionEvent arg0) {
				// TODO Auto-generated method stub
				System.out.println("jb_end action");
				String classURI = searchClass(jtf_end_class.getText());
				jtf_end_class.setText(classURI);
			}
			
		});
		

		jp2.add(jb_end,BorderLayout.EAST);

		
		
		JPanel jp3 = new JPanel();
		jtf_mode = new JTextField(3);
		jtf_mode.setText("0");
		jp3.add(jtf_mode);
		
		jcb_count_ins = new JCheckBox("Count Ins.",false);
		jp3.add(jcb_count_ins);
		
		JButton  jb_get_path = new JButton("Get Path");
		jp3.add(jb_get_path);
		
		map = new MapFactory();
		map.setSPARQLbuilder(this);

		
		jb_get_path.addActionListener(new ActionListener() {
					
			@Override
			public void actionPerformed(ActionEvent e) {
				System.out.println("get path action");
				//map.loadPathList(map.getDummyPathList());		
				
				try {
					System.out.println("getPaths:::>>>>"+jtf_start_class.getText()
							+"<===>"+jtf_end_class.getText());
					String mode_str = jtf_mode.getText();
					int mode = Integer.parseInt(mode_str);
					if(mode!=0 && mode!=1){
						mode = 0;
					}
					
					boolean count_ins = jcb_count_ins.isSelected();
					
					Path[] path = getOWLQueryBuilderImpl().getPaths(
							jtf_start_class.getText(), jtf_end_class.getText(),
							mode, count_ins);
					System.out.println("RESULT:::>>>>"+path.length);
					
					map.loadPathList(path);		
					//jta_query.setText(createSPARQL(path[0]));
					
				} catch (Exception e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
					System.out.println(e.toString());
				}
				
				
				
			}
		});
		
		this.add(jp1);
		this.add(jp2);
		this.add(jp3);
		
//		jta_query = new JTextArea();
//		this.add(new JScrollPane(jta_query), BorderLayout.CENTER);
//		JPanel jp_bottom = new JPanel();
//		jp_bottom.add(new JButton("make query"));
//		this.add(jp_bottom, BorderLayout.SOUTH);
	}
	

	String searchClass(String keyword){
		System.out.println("SearcClass for..."+keyword);
		String classURL ="";
		try {
			SClass[] classes = this.getOWLQueryBuilderImpl().getOWLClasses(null, keyword, false);
			DefaultListModel model  = new DefaultListModel();
			for(int i=0;i<classes.length;i++){
				model.addElement(classes[i].getClassURI());
			}
			JList list = new JList(model);
			
            JScrollPane listScrollPane = new JScrollPane(list);
            
			Object[] msg ={"Select a Class:",listScrollPane};
			
			
			int isOK = JOptionPane.showConfirmDialog(null,msg,"Select Class",JOptionPane.OK_CANCEL_OPTION,JOptionPane.QUESTION_MESSAGE);
			
			if(isOK==JOptionPane.OK_OPTION){
				int index = list.getSelectedIndex();
				classURL = model.getElementAt(index).toString();
			}
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		return classURL; 
	}
	
	public void setSPARQL(Path path,int num) throws Exception{
		String text = createSPARQL(path,num);
		//this.jta_query.setText(text);
		this.search_panel.setQueryText(text);
	}
	
	void makeOWLQueryBuilderImpl() {	
//		String sparqlEndpoint = "http://lsd.dbcls.jp/sparql";
		String sparqlEndpoint = search_panel.getSparqlAccessorForm().getCurrentEndPoint();
		
//		String sparqlEndpoint = "http://dbpedia.org/sparql";
		
		System.out.println("Create OWLQueryBuilder for "+sparqlEndpoint);
			
		builder = new OWLQueryBuilderImpl(sparqlEndpoint);
		/*
		
		String keyword = "\"artiste\"@fr";
		String[] graphURIs = new String[0];
		try {
			
	//	OWLQueryBuilder builder = new OWLQueryBuilderImpl(sparqlEndpoint);
		String[] clsURIs;
			clsURIs = builder.getOWLClasses(graphURIs, keyword);
		for(String cls: clsURIs){
			System.out.println(cls);
		}

		System.out.println("CLS");
		ClassLink[] cls = builder.getNextClass(null, clsURIs[0], 0);
		if( cls != null ){
			for( ClassLink cl: cls){
				System.out.println(cl.toString());
			}
		}

		System.out.println("CLS-INS");
		cls = builder.getNextClassViaInstanceLink(null, clsURIs[0], 100);
		if( cls != null ){
			for( ClassLink cl: cls){
				System.out.println(cl.toString());
			}
		}

		System.out.println("Instances");
		Instance[] ins = builder.getInstances(null, "\"A.C. Reed\"@en");
		if( ins != null ){
			for( Instance in: ins){
				System.out.println(in.toString());
			}
		}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			System.out.println(e.toString());
			e.printStackTrace();
		}*/
		
		//return (OWLQueryBuilderImpl) builder;
	}

public String createSPARQL(Path path) throws Exception {
	return createSPARQL(path, 0);
}

public String createSPARQL(Path path, int num) throws Exception {
		
		
		String startClass = path.getStartClass();
		List<ClassLink> classLinks = path.getClassLinks();
		
		StringBuffer queryStr = new StringBuffer();
		StringBuffer selStr = new StringBuffer();
		StringBuffer whereStr = new StringBuffer();
		if(num==0){
			num = classLinks.size();
		}
			
		queryStr.append("PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n");
		queryStr.append("PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n");
				
		selStr.append("SELECT ");
		whereStr.append("WHERE { \n");

		String properties = null;
		String objectClasses = null;
		String subjectClasses = null;
		Direction direction = null;
		int i = 0;
		int k = 0;
		for (ClassLink link :classLinks )
		{
			properties = link.getPropertyURI();
			objectClasses = link.getLinkedClassURI();
			direction = link.getDirection();
			
			if (i==0)
		    subjectClasses = startClass;
			
			selStr.append("?c").append(i).append(" ");
			selStr.append("?l").append(i).append(" ");
			
			if(i == classLinks.size())
				selStr.append("\n");
			
			
			whereStr.append("?c").append(i).
			append(" rdf:type ").
			append("<").
			append(subjectClasses).
			append(">").
			append(".\n");
			
			whereStr.append("OPTIONAL{\n?c"+i+" rdfs:label ?l"+i+".}\n");

						
			if(direction == Direction.forward)
			{
			whereStr.append("?c").append(i).append(" ");
			whereStr.append("<").append(properties).append("> ");			
			whereStr.append("?c").append(i+1).append(".\n");			
			}
			else
			{
				whereStr.append("?c").append(i+1).append(" ");
				whereStr.append("<").append(properties).append("> ");
				whereStr.append("?c").append(i).append(".\n");
			}
			
			subjectClasses = objectClasses;
			i++;
			k++;
			if(k>=num){
				break;
			}
		}
		
		selStr.append("?c").append(i).append(" \n");
		selStr.append("?l").append(i).append(" \n");
		whereStr.append("?c").append(i).append(" rdf:type ").
		    append("<").
		    append(subjectClasses).
		    append(">").
			append(".\n");
		whereStr.append("OPTIONAL{\n?c"+i+" rdfs:label ?l"+i+".}\n");
	
					
		queryStr.append(selStr).append(whereStr);
		
		queryStr.append("}");
		//OPTIONAL
		queryStr.append("LIMIT 100\n");;
		
		//System.out.println(queryStr);
		return queryStr.toString();
	}


	
}
