/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggSumDistinct
extends AggregatorBase {
    private Expr expr;
    private static final NodeValue noValuesToSum = NodeValue.nvZERO;

    public AggSumDistinct(Expr expr) {
        this.expr = expr;
    }

    @Override
    public Aggregator copy(Expr expr) {
        return new AggSumDistinct(expr);
    }

    @Override
    public String toString() {
        return "sum(distinct " + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    @Override
    public String toPrefixString() {
        return "(sum distinct " + WriterExpr.asString(this.expr) + ")";
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccSumDistinct(this.expr);
    }

    @Override
    public Expr getExpr() {
        return this.expr;
    }

    @Override
    public int hashCode() {
        return 0x17D ^ this.expr.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggSumDistinct)) {
            return false;
        }
        AggSumDistinct agg = (AggSumDistinct)other;
        return agg.getExpr().equals(this.getExpr());
    }

    @Override
    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToSum);
    }

    class AccSumDistinct
    extends AccumulatorDistinctExpr {
        private NodeValue total;

        public AccSumDistinct(Expr expr) {
            super(expr);
            this.total = null;
        }

        @Override
        public void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (nv.isNumber()) {
                this.total = this.total == null ? nv : XSDFuncOp.add(nv, this.total);
            } else {
                throw new ExprEvalException("Not a number: " + nv);
            }
        }

        @Override
        public NodeValue getAccValue() {
            return this.total;
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }
    }
}

