/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class EncodeForUri
implements Function {
    public String getURI() {
        return ((Object)FN.ENCODE_FOR_URI).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("ENCODE_FOR_URI requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            if (QueryEvaluationUtil.isStringLiteral(literal) || literal.getLanguage() != null) {
                String lexValue = literal.getLabel();
                return valueFactory.createLiteral(this.encodeUri(lexValue));
            }
            throw new ValueExprEvaluationException("Invalid argument for ENCODE_FOR_URI: " + literal);
        }
        throw new ValueExprEvaluationException("Invalid argument for ENCODE_FOR_URI: " + args[0]);
    }

    private String encodeUri(String uri) {
        StringBuilder buf = new StringBuilder(uri.length() * 2);
        int uriLen = uri.length();
        for (int i = 0; i < uriLen; ++i) {
            char c = uri.charAt(i);
            if (this.isUnreserved(c)) {
                buf.append(c);
                continue;
            }
            buf.append('%');
            String hexVal = Integer.toHexString(c);
            if (hexVal.length() == 1) {
                buf.append('0');
            }
            buf.append(hexVal);
        }
        return buf.toString();
    }

    private final boolean isUnreserved(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '.' || c == '_' || c == '~';
    }
}

