/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.BooleanLiteralImpl;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StrStarts
implements Function {
    public String getURI() {
        return ((Object)FN.STARTS_WITH).toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("STRSTARTS requires 2 arguments, got " + args.length);
        }
        Value leftVal = args[0];
        Value rightVal = args[1];
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            Literal leftLit = (Literal)leftVal;
            Literal rightLit = (Literal)rightVal;
            if (leftLit.getLanguage() != null) {
                if (rightLit.getLanguage() == null || rightLit.getLanguage().equals(leftLit.getLanguage())) {
                    String leftLexVal = leftLit.getLabel();
                    String rightLexVal = rightLit.getLabel();
                    return BooleanLiteralImpl.valueOf(leftLexVal.startsWith(rightLexVal));
                }
                throw new ValueExprEvaluationException("incompatible operands for STRSTARTS function");
            }
            if (QueryEvaluationUtil.isStringLiteral(leftLit)) {
                if (QueryEvaluationUtil.isStringLiteral(rightLit)) {
                    String leftLexVal = leftLit.getLabel();
                    String rightLexVal = rightLit.getLabel();
                    return BooleanLiteralImpl.valueOf(leftLexVal.startsWith(rightLexVal));
                }
                throw new ValueExprEvaluationException("incompatible operands for STRSTARTS function");
            }
            throw new ValueExprEvaluationException("incompatible operands for STRSTARTS function");
        }
        throw new ValueExprEvaluationException("STRSTARTS function expects literal operands");
    }
}

