/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggSample
extends AggregatorBase {
    private final Expr expr;

    public AggSample(Expr expr) {
        this.expr = expr;
    }

    @Override
    public Aggregator copy(Expr expr) {
        return new AggSample(expr);
    }

    @Override
    public String toString() {
        return "sample(" + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    @Override
    public String toPrefixString() {
        return "(sample " + WriterExpr.asString(this.expr) + ")";
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccSample(this.expr);
    }

    @Override
    public Expr getExpr() {
        return this.expr;
    }

    @Override
    public Node getValueEmpty() {
        return null;
    }

    @Override
    public int hashCode() {
        return 0x17A ^ this.expr.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggSample)) {
            return false;
        }
        AggSample agg = (AggSample)other;
        return agg.getExpr().equals(this.getExpr());
    }

    private static class AccSample
    extends AccumulatorExpr {
        private NodeValue sampleSoFar = null;

        public AccSample(Expr expr) {
            super(expr);
        }

        @Override
        public void accumulate(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (this.sampleSoFar == null) {
                this.sampleSoFar = nv;
                return;
            }
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getAccValue() {
            return this.sampleSoFar;
        }
    }
}

