/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.handler.AGLongHandler;
import com.franz.agraph.http.handler.AGRDFHandler;
import com.franz.agraph.repository.AGQuery;
import com.franz.agraph.repository.AGRepositoryConnection;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.impl.GraphQueryResultImpl;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.helpers.StatementCollector;

public class AGGraphQuery
extends AGQuery
implements GraphQuery {
    public AGGraphQuery(AGRepositoryConnection con, QueryLanguage ql, String queryString, String baseURI) {
        super(con, ql, queryString, baseURI);
    }

    public GraphQueryResult evaluate() throws QueryEvaluationException {
        try {
            StatementCollector collector = new StatementCollector();
            this.evaluate((RDFHandler)collector);
            return new GraphQueryResultImpl(collector.getNamespaces(), (Iterable)collector.getStatements());
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void evaluate(RDFHandler handler) throws QueryEvaluationException, RDFHandlerException {
        this.evaluate(new AGRDFHandler(RDFFormat.NTRIPLES, handler, this.httpCon.getValueFactory(), this.httpCon.getHttpRepoClient().getAllowExternalBlankNodeIds()));
    }

    public long count() throws QueryEvaluationException {
        AGLongHandler handler = new AGLongHandler();
        this.evaluate(handler);
        return handler.getResult();
    }
}

