/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class StatementImpl
implements Statement {
    private static final long serialVersionUID = 8707542157460228077L;
    private final Resource subject;
    private final URI predicate;
    private final Value object;

    public StatementImpl(Resource subject, URI predicate, Value object) {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public Resource getSubject() {
        return this.subject;
    }

    public URI getPredicate() {
        return this.predicate;
    }

    public Value getObject() {
        return this.object;
    }

    public Resource getContext() {
        return null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Statement) {
            Statement otherSt = (Statement)other;
            return this.object.equals(otherSt.getObject()) && this.subject.equals(otherSt.getSubject()) && ((Object)this.predicate).equals(otherSt.getPredicate());
        }
        return false;
    }

    public int hashCode() {
        return 961 * this.subject.hashCode() + 31 * ((Object)this.predicate).hashCode() + this.object.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("(");
        sb.append(this.getSubject());
        sb.append(", ");
        sb.append(this.getPredicate());
        sb.append(", ");
        sb.append(this.getObject());
        sb.append(")");
        return sb.toString();
    }
}

